<?php

namespace Illuminate\Foundation\Auth;

use Illuminate\Auth\Events\Registered;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Modules\security\SiteApp;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

trait RegistersUsers
{
    use RedirectsUsers;

    /**
     * Show the application registration form.
     *
     * @return \Illuminate\View\View
     */
    public function showRegistrationForm()
    {
        if(Session::has('consent')){
            Session::forget('consent');
            $metier = DB::table('mdl_metier')->get();

            $title = DB::table('mdl_title')->get();
            // $metier = [];
            // $title = [];
            
            return view('auth.register',[
                'rol'=>1,
                'metier'=>$metier,
                'title'=>$title,
                'check'=>0
            ]);
        }else{
            return redirect('/consent');
        }
        
    }

    /**
     * Handle a registration request for the application.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Http\JsonResponse
     */
    public function register(Request $request)
    {
        // dd($request->all());
        Session::put('consent',1);
        $this->validator($request->all())->validate();

        event(new Registered($user = $this->create($request->all())));

        // $this->guard()->login($user);
        if ($response = $this->registered($request, $user)) {
            return $response;
        }
        // dd($this->redirectPath());
        
        Session::put('register',1);
        Session::put('person_id',$request->id_card);
        // return $request->wantsJson()
        //             ? new JsonResponse([], 201)
        //             : redirect($this->redirectPath());
        return $request->wantsJson()
                    ? new JsonResponse([], 201)
                    : redirect('/register');
    }

    /**
     * Get the guard to be used during registration.
     *
     * @return \Illuminate\Contracts\Auth\StatefulGuard
     */
    protected function guard()
    {
        return Auth::guard();
    }

    /**
     * The user has been registered.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  mixed  $user
     * @return mixed
     */
    protected function registered(Request $request, $user)
    {
        //
    }
}
