
@if ($paginator->hasPages())
    
<ul class="pagination bootpag">
  @if ($paginator->onFirstPage())
    <li data-lp="1" class="prev disabled"><a href="javascript:void(0);">«</a></li>
  @else     
    <li data-lp="1" class="prev"><a href="{{ $paginator->previousPageUrl() }}">«</a></li>
  @endif

  @foreach ($elements as $element)
      {{-- "Three Dots" Separator --}}
          @if (is_string($element))
              <li><span class="pagination-ellipsis"><span>{{ $element }}</span></span></li>
          @endif

      {{-- Array Of Links --}}
      @if (is_array($element))
          @foreach ($element as $page => $url)
              @if ($page == $paginator->currentPage())
             
                  <li data-lp="{{ $page }}" class="active"><a href="javascript:void(0);">{{ $page }}</a></li>
              @else

                  <li data-lp="{{ $page }}" ><a href="{{ $url }}">{{ $page }}</a></li>
              @endif
          @endforeach
      @endif
  @endforeach
  @if ($paginator->hasMorePages())
      <li data-lp="1" class="next"><a href="{{ $paginator->nextPageUrl() }}">»</a></li>
  @else
      <li data-lp="1" class="next disabled"><a href="javascript:void(0);">»</a></li>
  @endif
  
</ul>
@endif
