@extends('layouts.app-home')
@section('title','register')
@section('head')
@endsection
@section('content')
@include('sweet::alert')
<div class="col-sm-12 from_login" id="from_register" style="padding-top: 20px;">
    <form method="POST" action="{{ route('register') }}">
        @csrf
        <div class="col-sm-12 "  >
            <div class="row m-b-20 m-t-20">
                <div class="col-md-12">
                    <h3 class="text-center" style="font-weight: bold;">ลงทะเบียน</h3>
                </div>
            </div>
        @if($rol == 1)
            <div class="form-group row">
                <label for="username" class="col-md-12 col-form-label">{{ trans('auth.login.user')}} <span class="text-danger">*</span></label>

                <div class="col-md-12">
                    <input id="username" type="text" placeholder="{{ trans('auth.login.user')}}" class="form-control @error('username') is-invalid @enderror" name="username" value="{{ old('username') }}" required  maxlength="15" minlength="3" autofocus onchange="check_username(this.value);" onkeypress="return UserLogin(event)">
                    <input type="hidden" value="1" name="role_id">
                    <span class="messages" id="mes_username">{{trans('security.messages.username')}} <span class="messages1" id="n_user"></span></span>
                    @error('username')
                        <span class="invalid-feedback" role="alert">
                            <strong>ชื่อผู้ใช้งานซ้ำ</strong>
                        </span>
                    @enderror
                </div>
            </div>
            <div class="form-group row">
                <label for="emp_mobile_no" class="col-md-12 col-form-label">{{ trans('auth.register.mobile')}}</label>

                <div class="col-md-12">
                    <input id="emp_mobile_no" type="mobile" placeholder="{{ trans('auth.register.mobile')}}" class="form-control @error('emp_mobile_no') is-invalid @enderror" name="emp_mobile_no" value="{{ old('emp_mobile_no') }}"  pattern="[0]{1}[1-9]{1}[-][0-9]{1}[0-9]{3}[-][0-9]{4}" title="{{'09-9999-9999'}}" maxlength="12" onkeyup="autoTab2(this,2)" onkeypress="return Numbers(event)" onchange="autoTab1(this,2);">

                    @error('emp_mobile_no')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                    @enderror
                </div>
            </div>
            <div class="form-group row">
                <label for="emp_mobile_no" class="col-md-12 col-form-label">{{ trans('auth.register.id_card')}}</label>

                <div class="col-md-12">
                    <input id="id_card" type="text" placeholder="{{ trans('auth.register.id_card')}}" class="form-control @error('id_card') is-invalid @enderror" name="id_card" value="{{ old('id_card') }}"  maxlength="17" onkeyup="autoTab2(this,1)" onkeypress="return Numbers(event)">

                    @error('id_card')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                    @enderror
                </div>
            </div>
            <div class="form-group row">
                <label for="emp_mobile_no" class="col-md-12 col-form-label">{{ trans('auth.register.email')}}</label>

                <div class="col-md-12">
                    <input id="email" type="email" placeholder="{{ trans('auth.register.email')}}" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}"  maxlength="100" >

                    @error('email')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                    @enderror
                </div>
            </div>
            <div class="form-group row">
                <label for="title" class="col-md-12 col-form-label">{{ trans('auth.register.title')}} <span class="text-danger">*</span></label>

                <div class="col-md-12">
                    <select name="title" id="title" class="form-control" required >
                        <option value="">{{trans('main.select')}}</option>
                    @foreach($title as $key=>$value)
                        <option value="{{$value->title_name}}">{{$value->title_name}}</option>
                    @endforeach
                    </select>
                    @error('title')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                    @enderror
                </div>
            </div>
                <div class="form-group row">
                    <div class="col-md-6" style="padding: 0px">
                        <label for="firstname" class="col-md-12  col-form-label">{{ trans('auth.register.fname')}} <span class="text-danger">*</span></label>

                        <div class="col-md-12">
                            <input id="firstname" type="text" placeholder="{{ trans('auth.register.fname')}}" class="form-control @error('firstname') is-invalid @enderror" name="firstname" value="{{ old('firstname') }}" required autocomplete="firstname" maxlength="25" autofocus>
                            <input type="hidden" value="1" name="role_id">
                            @error('firstname')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6" style="padding: 0px">
                        <label for="lastname" class="col-md-12 col-form-label">{{ trans('auth.register.lname')}} <span class="text-danger">*</span></label>

                        <div class="col-md-12">
                            <input id="lastname" type="text" placeholder="{{ trans('auth.register.lname')}}"  class="form-control @error('lastname') is-invalid @enderror" name="lastname" value="{{ old('lastname') }}" required autocomplete="lastname" autofocus>
                            <input type="hidden" value="1" name="role_id">
                            @error('lastname')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>
                </div>
                <div class="form-group row">
                    <label for="emp_type" class="col-md-12 col-form-label">{{ trans('auth.register.type')}} <span class="text-danger">*</span></label>
    
                    <div class="col-md-12">
                        <select name="emp_type" id="emp_type" class="form-control" required >
                            <option value="">{{trans('main.select')}}</option>
                            @foreach($metier as $key=>$value)
                                <option value="{{$value->metier_name}}">{{$value->metier_name}}</option>
                            @endforeach             
                        </select>
                        @error('emp_type')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                </div>

                <div class="form-group row">
                    <label for="password" class="col-md-12 col-form-label">{{ trans('auth.register.password')}} <span class="text-danger">*</span></label>

                    <div class="col-md-12 input-group " style="margin-bottom:0px">
                        <input id="password" type="password" placeholder="{{ trans('auth.login.password1')}}" class="form-control col-md-12 @error('password') is-invalid @enderror" name="password" required autocomplete="new-password" minlength="8">
                        <span toggle="#password" class="fa fa-fw fa-eye field-icon toggle-password"></span>
                    </div>
                    <div class="col-md-12 ">
                        @error('password')
                            <span class="invalid-feedback" role="alert" style="display:unset;">
                                <strong>รหัสผ่านไม่ตรงกัน</strong>
                            </span>
                        @enderror
                    </div>
                </div>

                <div class="form-group row">
                    <label for="password-confirm" class="col-md-12 col-form-label">{{ trans('auth.register.cpassword')}} <span class="text-danger">*</span></label>

                    <div class="col-md-12 input-group">
                        <input id="password-confirm" type="password" placeholder="{{ trans('auth.login.password1')}}" class="form-control" name="password_confirmation" required autocomplete="new-password">
                        <span toggle="#password-confirm" class="fa fa-fw fa-eye field-icon toggle-password-confirm"></span>
                    </div>

                </div>
                
                <div class=" row m-t-30 box2">
                    <div class="col-md-5 ord2">
                        <button type="button" class="btn btn-danger btn-md btn-block waves-effect waves-light text-center m-b-20" onclick="set_login();">ยกเลิก</button>
                    </div>
                    <div class="col-md-7 ord1">
                        <button type="submit" class="btn btn-primary  btn-md btn-block waves-effect waves-light text-center m-b-20">
                            {{ trans('main.btn.register')}}
                        </button>
                    </div>
                </div>
            @else
            <div class="form-group row" style="margin: 0px;padding: 0px;">
                <div class="col-sm-12 row" id="field_emp" style="margin: 0px;padding: 0px;">
                    <div class="col-md-12" style="margin: 0px;padding: 0px;">
                        <div class="col-md-12 text-center p-20" style="background-color: #EEEEEE;border-radius: 10px;" >
                            <label style="color: #228C22"><b>ลงทะเบียนสำเร็จ</b> กรุณาใช้ชื่อผู้ใช้งานและรหัสผ่าน <br>
                                ที่ท่านกำหนดเข้าสู่ระบบ สอบถามเพิ่มเติม <br>
                                กรุณาติดต่อเจ้าหน้าที่</label>
                        </div>
                    </div>
                </div>
              </div>           
         
              <div class="row m-t-30">
                  <div class="col-md-12">
                      <div class="col-md-12" style="margin: 0px;padding: 0px;">
                      <button type="button" class="btn btn-danger btn-md btn-block waves-effect waves-light text-center m-b-20" onclick="set_login();">เข้าสู่ระบบ</button>
                      </div>
                  </div>
              </div> 

            @endif
        </div>
    </form>
  </div>

  <script>
        @if($check == 1)
            swal("คุณขึ้นทะเบียนเกษตรกร","","warning")
        @endif
  </script>
@endsection
