$(function () {
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $('.delete').on('click',function (e) {
        e.preventDefault();
        var url=$(this).attr('href');
        console.log(url);
        swal({
            title: "Are you sure ?",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
            .then((willDelete) => {
                if (willDelete) {
                    $.ajax({
                        url: url,
                        type: 'DELETE',
                        statusCode: {
                            422: function(res) {
                                swal(res.responseJSON.message, "", "error")
                            }
                        },
                        success: function(res){
                            console.log(res);
                            if (res.type=='refresh')  {
                                swal(res.message, "", "success")
                                    .then((value) => {
                                        location.reload();
                                    });
                            } else {
                                swal(res.message, "", "success")
                                    .then((value) => {
                                        window.location.href = res.url;
                                    });
                            }

                        }
                    });

                } else {
                }
            });
    });
        $(".form-ajax").submit(function (event) {
            event.preventDefault();
            // alert( "Handler for .submit() called." );
            var _method = $(this).attr('method');
            var _action = $(this).attr('action');
            console.log(_method + ' ' + _action);

            $.ajax({
                url: _action,
                type: _method,
                data: $(this).serialize(),
                dataType: "json",
                statusCode: {
                    422: function (res) {

                        swal({
                            position: 'top-end',
                            icon: 'warning',
                            button:'Confirm',
                            title: 'This data is already in the system. Please change new data.',
                            showConfirmButton: false,
                        }
                        )

                        swal(res.responseJSON.title,"", "error")
                    }
                },
                success: function (res) {
                    console.log(res);
                    if (res.type == 'refresh') {
                        swal(res.message, "", "success")
                            .then((value) => {
                                location.reload();
                            });
                    } else {
                        swal(res.message, "", "success")
                            .then((value) => {
                                window.location.href = res.url;
                            });
                    }

                }
            });
        });
        $('#delete_project').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var pro_id = button.data('pro_id')
            var modal = $(this)
            modal.find('.modal-body #pro_id').val(pro_id);
        });
        $('#delete_tracking').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var track_id = button.data('track_id')
            var modal = $(this)
            modal.find('.modal-body #track_id').val(track_id);
        });
        $('#delete_category').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var cat_id = button.data('cat_id')
            var modal = $(this)
            modal.find('.modal-body #cat_id').val(cat_id);
        });
        $('#delete_employee').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var emp_id = button.data('emp_id')
            var modal = $(this)
            modal.find('.modal-body #emp_id').val(emp_id);
        });
        $('#delete_subcategory').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var sub_id = button.data('sub_id')
            var modal = $(this)
            modal.find('.modal-body #sub_id').val(sub_id);
        });
        $('#delete_incident').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var inc_id = button.data('inc_id')
            var modal = $(this)
            modal.find('.modal-body #inc_id').val(inc_id);
        });
        $('#delete_priority').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var pri_id = button.data('pri_id')
            var modal = $(this)
            modal.find('.modal-body #pri_id').val(pri_id);
        });
        $('#delete_status').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var sta_id = button.data('sta_id')
            var modal = $(this)
            modal.find('.modal-body #sta_id').val(sta_id);
        });
        $('#delete_user').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var use_id = button.data('use_id')
            var modal = $(this)
            modal.find('.modal-body #use_id').val(use_id);
        });
        $(document).ready(function () {
            $('#example').DataTable();
        });

    (function() {
        'use strict';
        window.addEventListener('load', function() {
            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.getElementsByClassName('needs-validation');
            // Loop over them and prevent submission
            var validation = Array.prototype.filter.call(forms, function(form) {
                form.addEventListener('submit', function(event) {
                    if (form.checkValidity() === false) {
                        event.preventDefault();
                        event.stopPropagation();
                    }
                    form.classList.add('was-validated');
                }, false);
            });
        }, false);
    })();


});


