<?php

namespace App\Models;

use Laravel\Sanctum\HasApiTokens;
use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use HasFactory, Notifiable,HasApiTokens;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $table = 'mdl_user';
    protected $fillable = [
        'username', 'email', 'password','type'
    ];

    
    protected $primaryKey = 'id';
    public $timestamps = false;
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'user_pswd', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
    
    const ADMIN_TYPE = 1;
    const DEFAULT_TYPE = 0;
    public function isAdmin(){
        return $this->type === self::ADMIN_TYPE;
    }
    public function jobtitle () {
        return $this->hasMany('App\Modules\security\Ref','ref_id','emp_title_id');
    }
    public function status () {
        return $this->hasMany('App\Modules\security\Ref','ref_id','user_status');
    }
    public function option () {
        return $this->hasMany('App\Modules\security\Ref','ref_id','emp_option');
    }  
    public function role (){
        return $this->belongsToMany('App\Modules\security\Role','sc_intr_usr_role','user_id','role_id')->orderBy('role_seq');
    } 
}
