<?php

namespace App\Http\Controllers\api;
use Auth;
use App\Models\User;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Intervention\Image\Facades\Image;
use App\Modules\security\Province;
use App\Modules\security\Ref;
use App\Modules\security\Zipcode;
use App\Modules\security\District;
use App\Modules\security\Amphur;
use App\Modules\security\Role;
use App\Modules\master\Organization;
use App\Modules\master\Member;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Carbon\Carbon;
use Input;
use App\Service\mclass;
use App\Service\count;
use App\Service\authapi;
use App\Modules\security\SiteApp;
class ElearningController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function pass($token = '')
    {
        if($token == 'djfhuSeuer845ht78vdJly832f8f7g89fifsdkjflknkjnjkerw;kSJFHfidfjoi'){
            $data = DB::table('mdl_course_completions')
                    ->select('mdl_course_completions.userid','mdl_course_completions.course','mdl_course_completions.timestarted','mdl_course_completions.timecompleted','mdl_course.fullname','mdl_course.idnumber'
                    ,'mdl_user.username','mdl_user.idnumber as personid','mdl_user.firstname','mdl_user.lastname','mdl_tool_certificate_issues.timecreated','mdl_tool_certificate_issues.code')
                    ->join('mdl_user','mdl_user.id','=','mdl_course_completions.userid')
                    ->join('mdl_course','mdl_course.id','=','mdl_course_completions.course')
                    ->leftjoin('mdl_tool_certificate_issues',function($qer){
                        $qer->on('mdl_tool_certificate_issues.userid','=','mdl_user.id')
                            ->on('mdl_tool_certificate_issues.courseid','=','mdl_course.id');
                    })
                    // ->join('mdl_grade_grades','mdl_grade_grades.userid','=','mdl_user.id')
                    // ->join('mdl_grade_items',function($qer){
                    //     $qer->on('mdl_grade_items.id','=','mdl_grade_grades.itemid')
                    //         ->on('mdl_grade_items.courseid','=','mdl_course.id');
                    // })

                    // ->join('mdl_grade_items','mdl_grade_items.courseid','=','mdl_course.id')
                    // ->join('mdl_grade_grades',function($qer){
                    //     $qer->on('mdl_grade_grades.itemid','=','mdl_grade_items.id')
                    //         ->on('mdl_grade_grades.userid','=','mdl_user.id');
                    // })
                    ->where('mdl_course_completions.timecompleted','>=',strtotime(Carbon::now(). ' - 1 days'))
                    // ->where('mdl_course_completions.timecompleted','>=',strtotime(date('2024-10-08')))
                    ->whereNotNull('mdl_course_completions.timecompleted')
                    ->get();
            // dd(Carbon::now());
            // dd(strtotime(Carbon::now(). ' - 1 days'));

            // dd(date('Y-m-d H:i:s',1703583091));
            foreach($data as $key=>$value){
                $data[$key]->score = [];
                $data[$key]->score = DB::table('mdl_grade_grades')
                                            ->select('mdl_grade_items.itemtype','mdl_grade_items.itemname','mdl_grade_items.grademax','mdl_grade_items.grademin','mdl_grade_items.gradepass','mdl_grade_grades.finalgrade')
                                            ->join('mdl_grade_items','mdl_grade_items.id','=','mdl_grade_grades.itemid')
                                            ->where('mdl_grade_grades.userid',$value->userid)
                                            ->where('mdl_grade_items.courseid',$value->course)
                                            ->get();
            }
            // dd($data);
            $respon['result'] = 1;
            $respon['message'] = 'success';
            $respon['total_data'] = count($data);
            $respon['data'] = $data;
        
            return response()->json($respon,200);  
        }else{
            $respon['result'] = -1;
            $respon['message'] = 'Forbidden';
        
            return response()->json($respon,403);  
        }
    }
    public function regis_course($token = '')
    {
        if($token == 'djfhuSeuer845ht78vdJly832f8f7g89fifsdkjflknkjnjkerw;kSJFHfidfjoi'){
            $data = DB::table('mdl_user_enrolments')
                    ->select('mdl_user_enrolments.userid','mdl_enrol.courseid as course','mdl_user_enrolments.timestart','mdl_course.fullname','mdl_course.idnumber'
                    ,'mdl_user.username','mdl_user.idnumber as personid','mdl_user.firstname','mdl_user.lastname'
                    ,'viewed.count_learn'
                    )
                    ->join('mdl_user','mdl_user.id','=','mdl_user_enrolments.userid')
                    ->join('mdl_enrol','mdl_enrol.id','=','mdl_user_enrolments.enrolid')
                    ->join('mdl_course','mdl_course.id','=','mdl_enrol.courseid')
                    ->leftjoin(
                        DB::raw("(select `mdl_course_modules_viewed`.`userid`,`mdl_course_modules`.`course`, count(`mdl_course_modules_viewed`.`userid`) as count_learn
                        from `mdl_course_modules_viewed` join `mdl_course_modules` on mdl_course_modules.id = mdl_course_modules_viewed.coursemoduleid
                        where mdl_course_modules_viewed.timecreated >=".strtotime(Carbon::now(). ' - 1 days')."
                        group by `mdl_course_modules_viewed`.`userid`,`mdl_course_modules`.`course`
                        ) `viewed` ")

                        ,function($qer){
                            $qer->on('viewed.userid','=','mdl_user.id')
                                ->on('viewed.course','=','mdl_course.id');
                        }
                    )
                    // ->leftjoin('mdl_course_modules','mdl_course_modules.course','=','mdl_course.id')
                    // ->leftjoin('mdl_course_modules_viewed',function($qer){
                    //     $qer->on('mdl_course_modules.id','=','mdl_course_modules_viewed.coursemoduleid')
                    //         ->on('mdl_user.id','=','mdl_course_modules_viewed.userid')
                    //         ->limit(1);
                    // })
                    ->where('mdl_enrol.enrol','self')
                    // ->where('mdl_user_enrolments.timestart','>=',strtotime(Carbon::now(). ' - 1 days'))
                    ->where(function($que){
                        $que->where('mdl_user_enrolments.timestart','>=',strtotime(Carbon::now(). ' - 1 days'))
                            ->orWhereNotNull('viewed.count_learn')
                            ;
                    })
                    // ->where('mdl_user_enrolments.timestart','>=',strtotime(date('2024-03-01')))
                    ->orderBy('mdl_user_enrolments.timestart','desc')
                    ->get();
            // dd($data);
            foreach($data as $key=>$value){
                // dd($value);
                $data[$key]->learn = DB::table('mdl_course_modules_viewed')
                                        ->join('mdl_user','mdl_user.id','=','mdl_course_modules_viewed.userid')
                                        ->join('mdl_course_modules','mdl_course_modules.id','=','mdl_course_modules_viewed.coursemoduleid')
                                        ->join('mdl_course','mdl_course.id','=','mdl_course_modules.course')
                                        ->where('mdl_course_modules_viewed.userid',$value->userid)
                                        ->where('mdl_course_modules.course',$value->course)
                                        ->count();
            }
            $respon['result'] = 1;
            $respon['message'] = 'success';
            $respon['total_data'] = count($data);
            $respon['data'] = $data;
        
            return response()->json($respon,200);  
        }else{
            $respon['result'] = -1;
            $respon['message'] = 'Forbidden';
        
            return response()->json($respon,403);  
        }
    }
    public function learn_course($token = '')
    {
        if($token == 'djfhuSeuer845ht78vdJly832f8f7g89fifsdkjflknkjnjkerw;kSJFHfidfjoi'){
            $data = DB::table('mdl_course_modules_viewed')
                    ->select('mdl_course_modules_viewed.userid','mdl_course_modules.course','mdl_course_modules_viewed.timecreated','mdl_course.fullname','mdl_course.idnumber'
                    ,'mdl_user.username','mdl_user.idnumber as personid','mdl_user.firstname','mdl_user.lastname')
                    ->join('mdl_user','mdl_user.id','=','mdl_course_modules_viewed.userid')
                    ->join('mdl_course_modules','mdl_course_modules.id','=','mdl_course_modules_viewed.coursemoduleid')
                    ->join('mdl_course','mdl_course.id','=','mdl_course_modules.course')
                    // ->where('mdl_course_modules_viewed.timecreated','>=',strtotime(Carbon::now(). ' - 1 days'))
                    ->get();
           
            $respon['result'] = 1;
            $respon['message'] = 'success';
            $respon['data'] = $data;
        
            return response()->json($respon,200);  
        }else{
            $respon['result'] = -1;
            $respon['message'] = 'Forbidden';
        
            return response()->json($respon,403);  
        }
    }
    public function update_emp_rnk(Request $request)
    {
        if($request->token == 'djfhuSeuer845ht78vdJly832f8f7g89fifsdkjflknkjnjkerw;kSJFHfidfjoi'){
            $user = $request->user;
            $rnk = $request->rnk;
            $emp = DB::table('mdl_user')->where('idnumber',$user)->first();
            // dd($emp->id);
            if(!empty($emp)){
                $data = DB::table('mdl_user_info_data')
                ->where('userid',$emp->id)
                ->where('fieldid',1)
                // ->get();
                ->update([
                    'data'=>$rnk
                ]);
                // dd($data);

            }
                    
            // dd(Carbon::now());
            // dd(strtotime(Carbon::now(). ' - 1 days'));

            // dd(date('Y-m-d H:i:s',1703583091));
            
            $respon['result'] = 1;
            $respon['message'] = 'success';
            return response()->json($respon,200);  
        }else{
            $respon['result'] = -1;
            $respon['message'] = 'Forbidden';
        
            return response()->json($respon,403);  
        }
    }
    public function update_emp(Request $request)
    {
        if($request->token == 'djfhuSeuer845ht78vdJly832f8f7g89fifsdkjflknkjnjkerw;kSJFHfidfjoi'){
            $user = $request->user;
            $rnk = $request->rnk;
            $emp = User::where('idnumber',$user)->first();
            // dd($emp->id);
            if(!empty($emp)){
                if($request['dob']){
                    $emp->password = Hash::make( intval(date('d', strtotime($request['dob']))).intval(date('m', strtotime($request['dob']))).(date('Y', strtotime($request['dob']))+543));
                }
                if($request['firstname']){
                    $emp->firstname = $request['firstname'];
                }
                if($request['lastname']){
                    $emp->lastname = $request['lastname'];
                }
                if($request['title']){
                    $emp->middlename = $request['title'];
                }
                $emp->save();  
                if($request['rnk']){
                    DB::table('mdl_user_info_data')
                    ->where('userid',$emp->id)
                    ->where('fieldid',1)
                    ->update([
                        'data'=>$request['rnk']
                    ]);
                }
                if($request['dob']){
                    DB::table('mdl_user_info_data')
                    ->where('userid',$emp->id)
                    ->where('fieldid',2)
                    ->update([
                        'data'=>strtotime($request['dob'])
                    ]);
                }
                if($request['emp_type']){
                    DB::table('mdl_user_info_data')
                    ->where('userid',$emp->id)
                    ->where('fieldid',3)
                    ->update([
                        'data'=>$request['emp_type']
                    ]);
                }
                if($request['title']){
                    DB::table('mdl_user_info_data')
                    ->where('userid',$emp->id)
                    ->where('fieldid',5)
                    ->update([
                        'data'=>$request['title']
                    ]);
                } 
            }else{
                $create = new User();
                $create->auth = 'manual';
                $create->confirmed = 1;
                $create->policyagreed = 0;
                $create->deleted = 0;
                $create->policyagreed = 0;
                $create->suspended = 0;
                $create->mnethostid = 1;
                $create->username = str_replace('-','',$user);
                $create->password = Hash::make( intval(date('d', strtotime($request['dob']))).intval(date('m', strtotime($request['dob']))).(date('Y', strtotime($request['dob']))+543));
                $create->firstname = $request['firstname'];
                $create->lastname = $request['lastname'];
                $create->middlename = $request['title'];
                $create->idnumber = $user;
                $create->email = '';
                $create->phone1 = '';
                $create->phone2 = '';
                $create->institution = '';
                $create->department = '';
                $create->address = '';
                $create->city = '';
                $create->country = '';
                $create->theme = '';
                $create->lastip = '';
                $create->secret = '';
                $create->description = '';
                $create->save();

                DB::table('mdl_cohort_members')->insert([
                    'userid'=>$create->id,
                    'cohortid'=>1,
                    'timeadded'=>strtotime(Carbon::now())
                ]);
                // dd($create);
                DB::table('mdl_user_info_data')->insert([
                    'userid'=>$create->id,
                    'fieldid'=>1,
                    'data'=>$request['rnk'],
                    'dataformat'=>0
                ]);
                DB::table('mdl_user_info_data')->insert([
                    'userid'=>$create->id,
                    'fieldid'=>2,
                    'data'=>strtotime($request['dob']),
                    'dataformat'=>0
                ]);
                DB::table('mdl_user_info_data')->insert([
                    'userid'=>$create->id,
                    'fieldid'=>3,
                    'data'=>$request['emp_type'],
                    'dataformat'=>0
                ]);
                DB::table('mdl_user_info_data')->insert([
                    'userid'=>$create->id,
                    'fieldid'=>5,
                    'data'=>$request['title'],
                    'dataformat'=>0
                ]);
                
                $ser = DB::table('mdl_enrol')
                    ->join('mdl_course','mdl_course.id','=','mdl_enrol.courseid')
                    ->select('mdl_enrol.id')
                    ->where('enrol','manual')
                    ->where('idnumber','like','%CER%')
                    ->get();
                foreach($cer as $key=>$value){
                    DB::table('mdl_user_enrolments')->insert([
                        'userid'=>$create->id,
                        'status'=>0,
                        'enrolid'=>$value->id,
                        'timestart'=>strtotime(Carbon::now()),
                        'timeend'=>strtotime(Carbon::now()),
                        'modifierid'=>2,
                        'timecreated'=>strtotime(Carbon::now()),
                        'timemodified'=>strtotime(Carbon::now()),
                    ]);
                }
            }
            $respon['result'] = 1;
            $respon['message'] = 'success';
            return response()->json($respon,200);  
        }else{
            $respon['result'] = -1;
            $respon['message'] = 'Forbidden';
        
            return response()->json($respon,403);  
        }
    }
    public function update_emp_inactive(Request $request)
    {
        if($request->token == 'djfhuSeuer845ht78vdJly832f8f7g89fifsdkjflknkjnjkerw;kSJFHfidfjoi'){
            $user = $request->user;
            $emp = DB::table('mdl_user')
                    ->where('idnumber',$user)
                    ->update([
                        'suspended'=>$request->status_f
                    ]);
            if($request->status_f == 0){
                $emp = User::where('idnumber',$user)->first();
                if(!empty($emp)){
                    DB::table('mdl_user_info_data')->insert([
                        'userid'=>$emp->id,
                        'fieldid'=>1,
                        'data'=>$request->rnk_name,
                        'dataformat'=>0
                    ]);
                }
            }
            $respon['result'] = 1;
            $respon['message'] = 'success';
            return response()->json($respon,200);  
        }else{
            $respon['result'] = -1;
            $respon['message'] = 'Forbidden';
        
            return response()->json($respon,403);  
        }
    }
    public function new_emp(Request $request)
    {
        // dd($request);
        if($request->token == 'djfhuSeuer845ht78vdJly832f8f7g89fifsdkjflknkjnjkerw;kSJFHfidfjoi'){
            $check = User::where('idnumber',$request['id_card'])->first();
            if(empty($check)){
                $create = new User();
                $create->auth = 'manual';
                $create->confirmed = 1;
                $create->policyagreed = 0;
                $create->deleted = 0;
                $create->policyagreed = 0;
                $create->suspended = 0;
                $create->mnethostid = 1;
                $create->username = str_replace('-','',$request['id_card']);
                $create->password = Hash::make( intval(date('d', strtotime($request['dob']))).intval(date('m', strtotime($request['dob']))).(date('Y', strtotime($request['dob']))+543));
                $create->firstname = $request['firstname'];
                $create->lastname = $request['lastname'];
                $create->middlename = $request['title'];
                $create->idnumber = $request['id_card'];
                $create->email = '';
                $create->phone1 = '';
                $create->phone2 = '';
                $create->institution = '';
                $create->department = '';
                $create->address = '';
                $create->city = '';
                $create->country = '';
                $create->theme = '';
                $create->lastip = '';
                $create->secret = '';
                $create->description = '';
                $create->save();

                DB::table('mdl_cohort_members')->insert([
                    'userid'=>$create->id,
                    'cohortid'=>1,
                    'timeadded'=>strtotime(Carbon::now())
                ]);
                // dd($create);
                DB::table('mdl_user_info_data')->insert([
                    'userid'=>$create->id,
                    'fieldid'=>1,
                    'data'=>$request['rnk'],
                    'dataformat'=>0
                ]);
                DB::table('mdl_user_info_data')->insert([
                    'userid'=>$create->id,
                    'fieldid'=>2,
                    'data'=>strtotime($request['dob']),
                    'dataformat'=>0
                ]);
                DB::table('mdl_user_info_data')->insert([
                    'userid'=>$create->id,
                    'fieldid'=>3,
                    'data'=>$request['emp_type'],
                    'dataformat'=>0
                ]);
                DB::table('mdl_user_info_data')->insert([
                    'userid'=>$create->id,
                    'fieldid'=>5,
                    'data'=>$request['title'],
                    'dataformat'=>0
                ]);

                $ser = DB::table('mdl_enrol')
                    ->join('mdl_course','mdl_course.id','=','mdl_enrol.courseid')
                    ->select('mdl_enrol.id')
                    ->where('enrol','manual')
                    ->where('idnumber','like','%CER%')
                    ->get();
                foreach($cer as $key=>$value){
                    DB::table('mdl_user_enrolments')->insert([
                        'userid'=>$create->id,
                        'status'=>0,
                        'enrolid'=>$value->id,
                        'timestart'=>strtotime(Carbon::now()),
                        'timeend'=>strtotime(Carbon::now()),
                        'modifierid'=>2,
                        'timecreated'=>strtotime(Carbon::now()),
                        'timemodified'=>strtotime(Carbon::now()),
                    ]);
                }


                $respon['result'] = 1;
                $respon['data'] = [];
                $respon['data']['user_id'] = $create->id;
                $respon['message'] = 'success';
                return response()->json($respon,200);  
            }elseif($check->suspended == 1){
                $create = User::find($check->id);
                $create->auth = 'manual';
                $create->confirmed = 1;
                $create->policyagreed = 0;
                $create->deleted = 0;
                $create->policyagreed = 0;
                $create->suspended = 0;
                $create->mnethostid = 1;
                $create->username = str_replace('-','',$request['id_card']);
                $create->password = Hash::make( intval(date('d', strtotime($request['dob']))).intval(date('m', strtotime($request['dob']))).(date('Y', strtotime($request['dob']))+543));
                $create->firstname = $request['firstname'];
                $create->lastname = $request['lastname'];
                $create->middlename = $request['title'];
                $create->idnumber = $request['id_card'];
                $create->email = '';
                $create->phone1 = '';
                $create->phone2 = '';
                $create->institution = '';
                $create->department = '';
                $create->address = '';
                $create->city = '';
                $create->country = '';
                $create->theme = '';
                $create->lastip = '';
                $create->secret = '';
                $create->description = '';
                $create->save();

                if($request['rnk']){
                    DB::table('mdl_user_info_data')
                    ->where('userid',$check->id)
                    ->where('fieldid',1)
                    ->update([
                        'data'=>$request['rnk']
                    ]);
                }
                if($request['dob']){
                    DB::table('mdl_user_info_data')
                    ->where('userid',$check->id)
                    ->where('fieldid',2)
                    ->update([
                        'data'=>strtotime($request['dob'])
                    ]);
                }
                if($request['emp_type']){
                    DB::table('mdl_user_info_data')
                    ->where('userid',$check->id)
                    ->where('fieldid',3)
                    ->update([
                        'data'=>$request['emp_type']
                    ]);
                }
                if($request['title']){
                    DB::table('mdl_user_info_data')
                    ->where('userid',$check->id)
                    ->where('fieldid',5)
                    ->update([
                        'data'=>$request['title']
                    ]);
                } 

                $respon['result'] = 1;
                $respon['data'] = [];
                $respon['data']['user_id'] = $create->id;
                $respon['message'] = 'success';
                return response()->json($respon,200);  
            }else{
                $respon['result'] = -2;
                $respon['message'] = 'มีข้อมูลผู้ใช้งานแล้ว';
            
                return response()->json($respon,403);  
            }
        }else{
            $respon['result'] = -1;
            $respon['message'] = 'Forbidden';
        
            return response()->json($respon,403);  
        }
    }
   
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {


    }
    
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

}
