<?php

namespace App\Http\Controllers;
use Auth;
use App\Models\User;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Intervention\Image\Facades\Image;
use App\Modules\security\Province;
use App\Modules\security\Ref;
use App\Modules\security\Zipcode;
use App\Modules\security\District;
use App\Modules\security\Amphur;
use App\Modules\security\Role;
use App\Modules\master\Organization;
use App\Modules\master\Member;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Input;
use App\Service\mclass;
use App\Service\count;
use App\Service\authapi;
use App\Modules\security\SiteApp;
class HomeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('index');

        if(Session::has('consent')){
            Session::forget('consent');
            return view('auth.register');
        }else{
            return redirect('/consent');
        }
    }
    
    public function consent()
    {
        // $data = DB::table('mdl_user')->get();
        // dd($data);
        if(!Session::has('consent')){

            return view('layouts.consent',[
                'html' => '',
                'page'=>'',
                'type_page' => 0
            ]);
        }else{
           
            return redirect('/register');

        }
    }
    public function consent_store(Request $request)
    {
        Session::put('consent',1);
        return redirect('/register');
    }

   
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {


    }
    
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function zipcode(Request $request){
        $data = $request->get('data');
        $data1 = $request->get('amp');
        $data2 = $request->get('pro');
        $se_zipcode = Zipcode :: where('district_code',$data)
            ->where('amphur_code',$data1)
            ->where('province_code',$data2)
            ->get();
        if(count($se_zipcode)==0){
            $da = 0;
        }else{
            $da = $se_zipcode[0]->zipcode;
        }
        return response($da);
    }
    public function district(Request $request){
        $data = $request->get('data');
        $data1 = $request->get('pro');
        $se_amphur = District :: where('amphur_code',$data)
            ->where('province_code',$data1)
            ->orderBy('district_name','ASC')
            ->get();
        $da =  "<select name='district' id='district' class='form-control' style='width:100%;' onChange=\"get_zipcode(this)\">";
        $da =$da . "<option value='0' province='0' amphur='0'>".trans('main.select')."</option>\n";

        foreach($se_amphur as $se) {
            $da =$da . "<option value='".$se->district_code."' province='".$se->province_code."' amphur='".$se->amphur_code."'>".$se->district_name."</option> ";
        }

        $da =$da . "</select>\n";
        return response($da);
    }
    public function amphur(Request $request){
        $data = $request->get('data');

       
        $se_amphur = Amphur ::where('province_code',$data)
            ->orderBy('amphur_name','ASC')
            ->get();
        $da =  "<select name='amphur' id='amphur' class='form-control' style='width:100%;' onChange=\"get_district(this)\">";
        $da =$da . "<option value='0' province='0'>".trans('main.select')."</option>\n";

        foreach($se_amphur as $se) {
            $da =$da . "<option value='".$se->amphur_code."' province='".$se->province_code."'>".$se->amphur_name."</option> ";
        }
        $da =$da . "</select>\n";
        return response($da);
    }
    public function amphur_by_role(Request $request){
        $data = $request->get('data');

        $org = Mclass::get_location();
        $or = mclass::check_org_type(auth()->user()->emp_user_id);
    
        
        $se_amphur = Amphur ::where('province_code',$data);
            if(auth()->user()->type == 0 && $or[1] != 'RF-ORG-01' && $or[1] != 'RF-ORG-00'){
                if($or[1] == 'RF-ORG-04'){
                    $se_amphur =  $se_amphur->where('amphur_code',$org[2]);
                }
            }
            $se_amphur =  $se_amphur->orderBy('amphur_name','ASC')
            ->get();
        $da =  "<select name='amphur' id='amphur' class='form-control' style='width:100%;' onChange=\"get_district(this)\">";
        $da =$da . "<option value='0' province='0'>".trans('main.select')."</option>\n";

        foreach($se_amphur as $se) {
            $da =$da . "<option value='".$se->amphur_code."' province='".$se->province_code."'>".$se->amphur_name."</option> ";
        }
        $da =$da . "</select>\n";
        return response($da);
    }
    public function org_level(Request $request){
        $data = $request->get('data');
        $name = $request->get('name');
        $next = $request->get('next');
        $next1 = $request->get('next1');
        $se_amphur = Organization :: where('org_by_orgid',$data);

        $or = mclass::check_org_type(auth()->user()->emp_user_id);
        $org_emp = Organization::join('sc_ref','sc_ref.ref_id','mst_org.org_status')
                                        ->where('mst_org.org_id',Session::get('brn_id'))
                                       
                                        ->get();
        if($name == 'province_org'){
            if($or[1] == 'RF-ORG-02'){
                $se_amphur =  $se_amphur->where('org_by_orgid',Session::get('brn_id'));
            }elseif($or[1] == 'RF-ORG-03'){
                $se_amphur =  $se_amphur->where('org_id',Session::get('brn_id'));
            }elseif($or[1] == 'RF-ORG-04'){
                $se_amphur =  $se_amphur->where('org_id',$org_emp[0]->org[0]->org_id);
            }
        }
        if($name == 'amphur_org'){
            if($or[1] == 'RF-ORG-02'){
                // $se_amphur =  $se_amphur->where('org_by_orgid',Session::get('brn_id'));
            }elseif($or[1] == 'RF-ORG-03'){
                $se_amphur =  $se_amphur->where('org_by_orgid',Session::get('brn_id'));
            }elseif($or[1] == 'RF-ORG-04'){
                $se_amphur =  $se_amphur->where('org_id',Session::get('brn_id'));
            }
        }        
        $se_amphur =  $se_amphur->orderBy('org_name','ASC')
            ->get();
      
            $da =  "<select name='".$name."' id='".$name."' class='form-control' style='width:100%;' onChange=\"set_province(this.value,'".$next."','".$next1."','".$next1."')\">";
            $da =$da . "<option value='0'>".trans('main.select')."</option>\n";

            foreach($se_amphur as $se) {
                $da =$da . "<option value='".$se->org_id."'>".$se->org_shrt_name."</option> ";
            }
            $da =$da . "</select>\n";

        return response($da);
    }

    public function auth_general(Request $request){
            // $count_user = User::where('type_general',1)->count();

            
            $user1 = $this->generateUniqueUserName('ทั่วไป');

            $data['emp_mobile_no'] = '';
            $data['emp_first_name'] = 'ผู้ใช้งาน';
            $data['emp_last_name'] = 'ทั่วไป';
            $data['username'] = $user1;
            $data['password'] = '11114444';
            $data['type_general'] = 1;

            $ref = Ref::where('ref_code','RF-STA-01')->get();

            $create = new Member();     
            $create->first_name = $data['emp_first_name'];
            $create->last_name = $data['emp_last_name'];
            $create->mobile = $data['emp_mobile_no'];
            $create->member_status  = $ref[0]->ref_id;
            $create->create_date = Carbon::now();
            $create->create_by = $data['emp_first_name'];
            $create->modified_date = Carbon::now();
            $create->modified_by = $data['emp_first_name'];   
            $create->type_general = 1;
            $create->save();

            $data['farmer_info_id'] = $create->farmer_info_id;

            $user = authapi::register_store($data);

            if(!$request->is('api/*')){
                Auth::guard()->login($user);

                // return response(1);
                return redirect()->route('home.index'); 
            }else{
                
                $user->device_token_mobile = $request->token;
                $user->save();
                $user->tokens()->delete();


                $token = $user->createToken('psotman',['user']);
                Session::put('log_system',$request->system);
                Session::put('log_model',$request->model);
                Session::put('log_brand',$request->brand);

                count::inser_log_login($user->user_id,$user->emp_first_name,'login','','');

                

                
                // $bran = mclass::get_bran();
                return response()->json(['result'=>0,'message' => 'success','data'=>[
                    'Token'=>$token->plainTextToken,
                    'user_id'=>$user->user_id,
                    'user_firstname'=>$user->emp_first_name,
                    'user_lastname'=>$user->emp_last_name,
                    'user_pic'=>$user->emp_pic,
                    // 'bran'=>$bran
                ]]);
            }
            
            
        
    }

    public function generateUniqueUserName($username)
    {
        $username = strtolower($username);
        $variations = 0;

        while (true) {
            $newUserName = $username;
            if ($variations > 0) {
                $newUserName .= (string) $variations;
            }
            $userExist = User::where('username', $newUserName)->exists();
            if ($userExist) {
                $variations++;
            } else {
                $username = $newUserName;
                break;
            }
        }

        return $username;
    }
}
