<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Modules\security\SiteApp;
use App\Modules\security\Ref;
use App\Modules\security\AppModule;
use App\Modules\security\Program;
use App\Modules\security\Funct;
use App\Modules\security\Role;
use App\Modules\security\Menu;
use App\Modules\security\Log;
use App\Modules\far\SubScription;
use Redirect;
use App\Service\count;
use Illuminate\Support\Facades\Session;
use Auth;
use Carbon\Carbon;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;


        function ind($sub,$page,$type){


            $j = 0;
            $submenus = [];
            foreach ($sub as $key => $value) {
                if($type == 1){
                    $submenus[$j] = $this->setmenu_html($value,0,$page);
                }else{
                    $submenus[$j] = $this->setmenu_html_mobile($value,0,$page);
                }
                
                $j++;
            }
            return $submenus;
        }
    function setmenu_html($menu,$sublevel,$page){
        $submenu = '';
        $rep = SubScription::where('user_id',auth()->user()->user_id)->pluck('menu_id')->all();    
        $sub = Menu::join('sc_mdl_pgrm','sc_mdl_pgrm.mdl_pgrm_id','=','sc_menu.mdl_pgrm_id')
            ->where('menu_prn_id',$menu->menu_id)
            ->where(function ($qer) use ($rep){
                $qer->where('sc_mdl_pgrm.pgrm_type',1)
                ->orWhereIn('sc_menu.menu_id',$rep);
            })
            ->Orderby('menu_seq')
            ->get();
        if(count($sub) != 0){
            $submenu1 = [];
            $c = 0;
            $su = '';
            foreach ($sub as $key => $value) {
                $submenu1[$key] =  $this->getsubmenu($value);
                $subme[$c] = $value->pgrm_url;
                $su = $su."H".$value->pgrm_url." ";
                $c++;
            }
            
            foreach ($submenu1 as $key1 => $value1) {
                foreach ($value1 as $key2 => $value2) {
                   $subme[$c] = $value2;
                   $c++;
                }
                
            }

            $i=0;
            $active = (in_array($page,$subme)) ? 'pcoded-hasmenu  ':'pcoded-hasmenu ';
            $submenu = $submenu.'<li class="'.$active.$su.'" >
                <a href="javascript:void(0)">
                    <span class="pcoded-micon"><img src="/images/foliage.svg"  class="icon-menu1"></span>
                    <span class="pcoded-mtext">'.$menu->menu_name.'</span>';
                    if($menu->menu_count_item == 2  && auth()->user()->device_token != ""){
                        $submenu = $submenu.'<span class="menu_count" >
                       
                        <span class="menu_count_text" id="menu_count_'.$menu->pgrm_url.'">0</span>
                        </span>';
                    }
                        
                    $submenu = $submenu.'</a>
               
                <ul class="pcoded-submenu">';
            foreach ($sub as $key => $value) {
                $submenu.=  $this->setmenu_html($value,1,$page);
                $i++;
            }
            $submenu = $submenu.'</ul>
            </li>';
        }else{
       
            $active = ($page == $menu->pgrm_url) ? 'active':'';
            if($sublevel == 0){
                $submenu = $submenu.'<li class="P'.$menu->pgrm_url.'">
                <a href="'.route($menu->pgrm_url.'.index').'">
                    <span class="pcoded-micon"><img src="/images/foliage.svg"  class="icon-menu1"></span>
                    <span class="pcoded-mtext">'.$menu->menu_name.'</span>';
                    if($menu->menu_count_item == 2 && auth()->user()->device_token != ""){
                        $submenu = $submenu.'<span class="menu_count" >
                       
                        <span class="menu_count_text" id="menu_count_'.$menu->pgrm_url.'">0</span>
                        </span>';
                    }
                    
                $submenu = $submenu.'</a>
            </li>';
            }else{
                $submenu = $submenu.'<li class="P'.$menu->pgrm_url.'">
                        <a href="'.route($menu->pgrm_url.'.index').'">
                        <span class="pcoded-mtext">'.$menu->menu_name.'</span>
                        
                        </a>
                    </li>';
            }
        }
        
        return $submenu;

    }
    function setmenu_html_mobile($menu,$sublevel,$page){
        $submenu = '';

        
        $submenu = $submenu.'<a class="navbar-toggle" style="border: none;" href="/'.$menu->pgrm_url.'">
                    
                        <span class="'.$menu->menu_icon.'" style="color:#ffffff; font-size:1.5em;"></span>
                    </a>
                ';
            
        
        return $submenu;

    }
    function getsubmenu($menu){
        $submenu = [];

        $sub = Menu::join('sc_mdl_pgrm','sc_mdl_pgrm.mdl_pgrm_id','=','sc_menu.mdl_pgrm_id')
            ->where('menu_prn_id',$menu->menu_id)
            ->Orderby('menu_seq')
            ->get();
        if(count($sub) != 0){
            $submenu1 = [];
            foreach ($sub as $key => $value) {
                $submenu1[$key] =  $this->getsubmenu($value);
            }
            $c = 0;
            foreach ($submenu1 as $key1 => $value1) {
                foreach ($value1 as $key2 => $value2) {
                   $submenu[$c] = $value2;
                   $c++;
                }
                
            }
        }else{
            $submenu[0] = $menu->pgrm_url;
        }

        return $submenu;
    }
    public function menu($data,$type,$page){
        if(!Session::has('menu') || Session::get('menu_status') == 1){

            $menu_id = $this->get_id_menu();
            $html = '';

            // if($type == 1){
            //     $men = $menu_id[0];
            // }else{
            //     $men = $menu_id[1];
            // }
            
            foreach($menu_id as $key=>$men){
                $main = Menu::join('sc_ref','sc_ref.ref_id','menu_status')
                        ->where('ref_code','RF-STA-01')
                        ->where('menu_id',$men)
                        ->where('menu_level',0)
                        ->orderBy('menu_seq','asc')
                        ->first();
                

                $sub = Menu::join('sc_mdl_pgrm','sc_mdl_pgrm.mdl_pgrm_id','=','sc_menu.mdl_pgrm_id')
                        ->join('sc_ref','sc_ref.ref_id','menu_status')
                        ->where('ref_code','RF-STA-01')
                        ->where('main_id',$men)
                        ->where('menu_level',1)
                        // ->where(function ($qer) use ($rep){
                        //     $qer->where('sc_mdl_pgrm.pgrm_type',1)
                        //     ->orWhereIn('sc_menu.menu_id',$rep);
                        // })
                        ->orderBy('menu_seq','asc')
                        ->get();
                // dd($sub);    
                    if(count($sub) != 0){

                        $a = $this->ind($sub,$data,$type);
                        
                        foreach ($a as $value) {

                            $html = $html.$value;
                        } 
                        
                    }
            }
            Session::put('menu',$html);
            Session::put('menu_status',0);
        }else{
            $html = Session::get('menu');
        }

        if(Auth::check()){
            
            count::inser_log_login(Auth::user()->user_id,Auth::user()->emp_first_name,$data,$page,'');
        }
            return $html;
    } 
    public function get_id_menu(){
        
            if(!Session::has('brn_id') || Session::get('brn_id') == 0){
                $role = Role::join('sc_intr_usr_org_role','sc_intr_usr_org_role.role_id','=','sc_role.role_id')
                ->join('sc_intr_role_menu','sc_intr_role_menu.sc_role_role_id','sc_role.role_id')
                ->leftjoin('mst_emp_org','mst_emp_org.mst_intr_id','sc_intr_usr_org_role.mst_intr_id')
                ->join('sc_ref','sc_ref.ref_id','sc_role.role_status')
                ->join('sc_ref as a','a.ref_id','sc_intr_usr_org_role.role_status')
                ->where('sc_ref.ref_code','RF-STA-01')
                ->where('a.ref_code','RF-STA-01')
                ->where('sc_intr_usr_org_role.role_admin',Session::get('admin_type'))
                ->where('sc_intr_usr_org_role.user_id',Auth::user()->user_id)
                ->orderBy('role_seq','asc')
                ->get();
            }else{
                $role = Role::select('*','sc_intr_usr_org_role.user_id')
                ->join('sc_intr_usr_org_role','sc_intr_usr_org_role.role_id','=','sc_role.role_id')
                ->join('sc_intr_role_menu','sc_intr_role_menu.sc_role_role_id','sc_role.role_id')
                ->leftjoin('mst_emp_org','mst_emp_org.mst_intr_id','sc_intr_usr_org_role.mst_intr_id')
                ->join('sc_ref','sc_ref.ref_id','sc_role.role_status')
                ->join('sc_ref as a','a.ref_id','sc_intr_usr_org_role.role_status')
                ->where('sc_ref.ref_code','RF-STA-01')
                ->where('a.ref_code','RF-STA-01')
                ->where('sc_intr_usr_org_role.role_admin',Session::get('admin_type'))
                ->where('sc_intr_usr_org_role.user_id',Auth::user()->user_id)
                ->where('mst_emp_org.org_id',Session::get('brn_id'))
                ->orderBy('role_seq','asc')
                ->get();

                // dd($role);
            }
            
            
            
            $menu_id = [];
     

            foreach ($role as $key=>$roles) {
                $menu_id[$key] = $roles->sc_menu_menu_id;
     
            }
            
            return  $menu_id;      
    } 
    public function get_theme(){
        $id = 0;
        // dd($_SERVER['HTTP_HOST']);
        if(Session::has('app_url') && Session::get('app_url') != $_SERVER['HTTP_HOST']){
            return redirect('/');
        }
        // dd(Session::get('admin_type'));
        if(Session::has('admin_type')){
            $id = Session::get('admin_type');
        }
        $theme = DB::table('mst_theme')->where('thm_type',$id)->where('thm_default',1)->first();
        
        Session::forget('theme');
        Session::put('theme',$theme);
        // dd(Session::get('theme')->sidebar_bg);
    }
    public function role_menu(){
        if(Session::has('app_url') && Session::get('app_url') != $_SERVER['HTTP_HOST']){
            return [];
        }
        // if(!Session::has('theme')){
            $this->get_theme();
        // }
        if(!Session::has('role_menu') || Session::get('role_menu_status') == 1){
            $menu_id =  $this->get_id_menu(); 
            $submenu = [];
            $i = 0;
            foreach ($menu_id as $key1 => $value1) {
                $get = Menu::join('sc_mdl_pgrm','sc_mdl_pgrm.mdl_pgrm_id','=','sc_menu.mdl_pgrm_id')
                            ->where('main_id',$value1)->orderBy('menu_seq','asc')->get(); 

                foreach ($get as $key => $value) {
                $submenu[$i] = $value->pgrm_url;
                $i++;
                }
            }
            // dd($submenu);
            Session::put('role_menu',$submenu);
            Session::put('role_menu_status',0);

        }else{
            $submenu = Session::get('role_menu');
        }
            return  $submenu;   

    } 
    public function role_menu1(){
        
        
            $menu_id =  $this->get_id_menu(); 
            $submenu = [];
            $submenu[0] = [];
            $submenu[1] = [];
            $i = 0;
            foreach ($menu_id as $key1 => $value1) {
                $get = Menu::join('sc_mdl_pgrm','sc_mdl_pgrm.mdl_pgrm_id','=','sc_menu.mdl_pgrm_id')
                            ->where('main_id',$value1)
                            ->where('menu_level',1)
                            ->orderBy('menu_seq','asc')->get(); 

                foreach ($get as $key => $value) {
                    // $get1 = Menu::where('menu_prn_id',$value->menu_id)->count(); 
                    // if($get1 == 0 && !in_array($value->pgrm_url,$submenu[0])){
                    if(!in_array($value->pgrm_url,$submenu[0])){    
                        $submenu[0][$i] = $value->pgrm_url;
                        $submenu[1][$i] = $value->menu_name;
                        $i++;
                    }
                }
            }
            // dd($submenu);
            // Session::put('role_menu',$submenu[0]);
            // Session::put('role_menu_status',0);
            return  $submenu;   

    } 

    public function permission_role($page){
        
        // dd(Session::has('permission'.$page));
        if(!Session::has('permission'.$page)){
            $role = Role::join('sc_intr_usr_org_role','sc_intr_usr_org_role.role_id','=','sc_role.role_id')
                        ->join('sc_intr_role_menu','sc_intr_role_menu.sc_role_role_id','sc_role.role_id')
                        ->join('sc_menu','sc_menu.main_id','sc_intr_role_menu.sc_menu_menu_id')
                        ->join('sc_mdl_pgrm','sc_mdl_pgrm.mdl_pgrm_id','=','sc_menu.mdl_pgrm_id')
                        ->join('sc_ref as ref','ref.ref_id','sc_role.role_status')
                        ->join('sc_ref as ref1','ref1.ref_id','sc_menu.menu_status')
                        ->join('sc_ref as ref2','ref2.ref_id','sc_mdl_pgrm.pgrm_status')
                        ->join('sc_ref as ref3','ref3.ref_id','sc_intr_usr_org_role.role_status')
                        ->leftjoin('mst_emp_org','mst_emp_org.mst_intr_id','sc_intr_usr_org_role.mst_intr_id')
                        ->where('ref.ref_code','RF-STA-01')
                        ->where('ref1.ref_code','RF-STA-01')
                        ->where('ref2.ref_code','RF-STA-01')
                        ->where('ref3.ref_code','RF-STA-01')
                        ->where('sc_intr_usr_org_role.user_id',Auth::user()->user_id)
                        ->where('sc_mdl_pgrm.pgrm_url',$page)
                        ->where('mst_emp_org.org_id',Session::get('brn_id'))
                        ->orderBy('role_seq','asc')
                        ->get();

            if(count($role) == 0){
                 $role = Role::join('sc_intr_usr_org_role','sc_intr_usr_org_role.role_id','=','sc_role.role_id')
                        ->join('sc_intr_role_menu','sc_intr_role_menu.sc_role_role_id','sc_role.role_id')
                        ->join('sc_menu','sc_menu.main_id','sc_intr_role_menu.sc_menu_menu_id')
                        ->join('sc_mdl_pgrm','sc_mdl_pgrm.mdl_pgrm_id','=','sc_menu.mdl_pgrm_id')
                        ->join('sc_ref as ref','ref.ref_id','sc_role.role_status')
                        ->join('sc_ref as ref1','ref1.ref_id','sc_menu.menu_status')
                        ->join('sc_ref as ref2','ref2.ref_id','sc_mdl_pgrm.pgrm_status')
                        ->join('sc_ref as ref3','ref3.ref_id','sc_intr_usr_org_role.role_status')
                        ->where('ref.ref_code','RF-STA-01')
                        ->where('ref1.ref_code','RF-STA-01')
                        ->where('ref2.ref_code','RF-STA-01')
                        ->where('ref3.ref_code','RF-STA-01')
                        ->where('sc_intr_usr_org_role.user_id',Auth::user()->user_id)
                        ->where('sc_mdl_pgrm.pgrm_url',$page)
                        ->orderBy('role_seq','asc')
                        ->get();
            }
            // dd($role);
            $permission[0] = [];
            $permission[1] = [];

            foreach ($role as $key => $value) {
                $i=0;
                if($value->menu_c == 1){
                    $permission[0][$i] = 'C';
                    $i++;
                }
                if($value->menu_r == 1){
                    $permission[0][$i] = 'R';
                    $i++;
                }
                if($value->menu_u == 1){
                    $permission[0][$i] = 'U';
                    $i++;
                }
                if($value->menu_d == 1){
                    $permission[0][$i] = 'D';
                    $i++;
                }  
                $func = DB::table('sc_intr_fnct_menu')
                        ->join('sc_pgrm_fnct','sc_pgrm_fnct.mdl_fnct_id','=','sc_intr_fnct_menu.mdl_fnct_id')
                        ->where('mdl_pgrm_id',$value->mdl_pgrm_id)
                        ->where('menu_id',$value->menu_id)
                        ->get();   
                
                foreach ($func as $key1 => $value1) {
                    $permission[1][$key1][0] = $value1->mdl_fnct_code;
                    $j=1;
                    if($value1->fnct_c == 1){
                        $permission[1][$key1][$j] = 'C';
                        $j++;
                    }
                    if($value1->fnct_c == 1){
                        $permission[1][$key1][$j] = 'R';
                        $j++;
                    }
                    if($value1->fnct_c == 1){
                        $permission[1][$key1][$j] = 'U';
                        $j++;
                    }
                    if($value1->fnct_c == 1){
                        $permission[1][$key1][$j] = 'D';
                        $j++;
                    }
                }             
                break;
            }
            Session::put('permission'.$page,$permission);
           
        }else{
            $permission = Session::get('permission'.$page);
        }                

        return  $permission; 
    }    
}
