<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use App\Models\User;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;
use App\Modules\security\Role;
use App\Modules\security\User_Role;
use App\Modules\security\Ref;
use Illuminate\Support\Facades\DB;
use App\Service\authapi;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        // dd($data);
        return Validator::make($data, [
            'username' => ['required', 'string', 'max:25' , 'unique:mdl_user'],
            // 'emp_mobile_no' => ['required', 'string', 'max:13'],
            'firstname' => ['required', 'string', 'max:25'],
            'lastname' => ['required', 'string', 'max:25'],
     
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\User
     */
    protected function create(array $data)
    {
        // dd($data);
        $create = new User();
        $create->auth = 'manual';
        $create->confirmed = 1;
        $create->policyagreed = 0;
        $create->deleted = 0;
        $create->policyagreed = 0;
        $create->suspended = 0;
        $create->mnethostid = 1;
        $create->username = $data['username'];
        $create->password = Hash::make($data['password']);
        $create->firstname = $data['firstname'];
        $create->lastname = $data['lastname'];
        $create->idnumber = $data['id_card'] ? $data['id_card'] : '';
        $create->email = $data['email'] ? $data['email'] : '';
        $create->phone1 = $data['emp_mobile_no'] ? $data['emp_mobile_no'] : '';
        $create->phone2 = '';
        $create->institution = '';
        $create->department = '';
        $create->address = '';
        $create->city = '';
        $create->country = '';
        $create->theme = '';
        $create->lastip = '';
        $create->secret = '';
        $create->description = '';
        $create->save();
        // dd($create);

        DB::table('mdl_user_info_data')->insert([
            'userid'=>$create->id,
            'fieldid'=>5,
            'data'=>$data['title'],
            'dataformat'=>0
        ]);
        DB::table('mdl_user_info_data')->insert([
            'userid'=>$create->id,
            'fieldid'=>6,
            'data'=>$data['emp_type'],
            'dataformat'=>0
        ]);
        DB::table('mdl_cohort_members')->insert([
            'userid'=>$create->id,
            'cohortid'=>8,
            'timeadded'=>strtotime(Carbon::now())
        ]);
        return $create;
       
    }
}
