<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\URL;
use App\Modules\security\Ref;
use Socialite;
use App\User;
use App\Modules\master\Employee;
use Auth;
use Redirect;
use App\Member,App\Modules\security\SiteApp;
use App\Role;
use App\Project;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }
    protected function credentials(Request $request)
    {
        // dd(55);
        $ref_id = Ref::where('ref_code','RF-STA-01')->first();
        
        if($request->submit_type == 1){

            return ['username'=>strtolower($request->username),
                    'password' => $request->password, 
                    'user_status' => $ref_id->ref_id, 
                    'role_admin'=>1
                ];
        }else{
            return ['username'=>strtolower($request->username),
                'password' => $request->password, 
                'user_status' => $ref_id->ref_id, 
                'role_user'=>1
            ];
        }

    }
    protected function redirectTo()
    {
        // dd(Session::get('admin_type'));
        if(auth()->user()->isAdmin()) {
            return '/admin/';
        } else {
            $url = SiteApp::where('app_type',Session::get('admin_type'))->first();
            // dd($url);
            if(!empty($url)){
                Session::put('app_url',$url->app_url);
                return trans('auth.url').$url->app_url;
            }else{
                Session::put('app_url',$_SERVER['HTTP_HOST']);
                return '/';
            }
            
        }
    }
}
