/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.renderers.AbstractRenderer;
import net.sf.jasperreports.renderers.ResourceRenderer;
import net.sf.jasperreports.renderers.SimpleDataRenderer;
import org.w3c.tools.codec.Base64Decoder;

public class JRPrintImageSourceObject {
    public static final String EXCEPTION_MESSAGE_KEY_DECODING_ERROR = "xml.print.image.decoding.error";
    private JRPrintImage printImage;
    private final boolean isLazy;
    private boolean isEmbedded;

    public JRPrintImageSourceObject() {
        this(false);
    }

    public JRPrintImageSourceObject(boolean isLazy) {
        this.isLazy = isLazy;
    }

    public void setPrintImage(JRPrintImage printImage) {
        this.printImage = printImage;
    }

    public void setEmbedded(boolean isEmbedded) {
        this.isEmbedded = isEmbedded;
    }

    public void setImageSource(String imageSource) throws JRException {
        AbstractRenderer renderable = null;
        if (this.isLazy) {
            renderable = ResourceRenderer.getInstance(imageSource, true);
        } else if (this.isEmbedded) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(imageSource.getBytes("UTF-8"));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Base64Decoder decoder = new Base64Decoder(bais, baos);
                decoder.process();
                renderable = SimpleDataRenderer.getInstance(baos.toByteArray());
            }
            catch (Exception e) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_DECODING_ERROR, null, e);
            }
        } else {
            renderable = ResourceRenderer.getInstance(imageSource, false);
        }
        this.printImage.setRenderer(renderable);
    }
}

