/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.sf.jasperreports.engine.CommonReturnValue;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRScriptletException;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.ReturnValue;
import net.sf.jasperreports.engine.VariableReturnValue;
import net.sf.jasperreports.engine.fill.AbstractVariableReturnValueSourceContext;
import net.sf.jasperreports.engine.fill.BaseReportFiller;
import net.sf.jasperreports.engine.fill.FillDatasetPosition;
import net.sf.jasperreports.engine.fill.FillReturnValues;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.type.IncrementTypeEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRFillDatasetRun
implements JRDatasetRun {
    private static final Log log = LogFactory.getLog(JRFillDatasetRun.class);
    protected final BaseReportFiller filler;
    protected final JRFillExpressionEvaluator expressionEvaluator;
    protected final JRDatasetRun parentDatasetRun;
    protected final JRFillDataset dataset;
    protected JRExpression parametersMapExpression;
    protected JRDatasetParameter[] parameters;
    protected JRExpression connectionExpression;
    protected JRExpression dataSourceExpression;
    private FillReturnValues returnValues;
    private FillReturnValues.SourceContext returnValuesContext;

    public JRFillDatasetRun(JRBaseFiller filler, JRDatasetRun datasetRun, JRFillObjectFactory factory) {
        this(filler, filler.getExpressionEvaluator(), datasetRun, factory);
    }

    protected JRFillDatasetRun(JRDatasetRun datasetRun, JRFillObjectFactory factory) {
        this(factory.getFiller(), factory.getExpressionEvaluator(), datasetRun, factory);
    }

    protected JRFillDatasetRun(JRBaseFiller filler, JRFillExpressionEvaluator expressionEvaluator, JRDatasetRun datasetRun, JRFillObjectFactory factory) {
        this((BaseReportFiller)filler, expressionEvaluator, datasetRun, (JRFillDataset)filler.datasetMap.get(datasetRun.getDatasetName()));
        factory.put(datasetRun, this);
        this.initReturnValues(factory);
    }

    protected JRFillDatasetRun(BaseReportFiller filler, JRDatasetRun datasetRun, JRFillDataset dataset) {
        this(filler, filler.getExpressionEvaluator(), datasetRun, dataset);
    }

    protected JRFillDatasetRun(BaseReportFiller filler, JRFillExpressionEvaluator expressionEvaluator, JRDatasetRun datasetRun, JRFillDataset dataset) {
        this.filler = filler;
        this.expressionEvaluator = expressionEvaluator;
        this.dataset = dataset;
        this.parentDatasetRun = datasetRun;
        this.parametersMapExpression = datasetRun.getParametersMapExpression();
        this.parameters = datasetRun.getParameters();
        this.connectionExpression = datasetRun.getConnectionExpression();
        this.dataSourceExpression = datasetRun.getDataSourceExpression();
    }

    public JRFillDatasetRun(JRFillDatasetRun datasetRun, JRFillCloneFactory factory) {
        this.filler = datasetRun.filler;
        this.expressionEvaluator = datasetRun.expressionEvaluator;
        this.dataset = datasetRun.dataset;
        this.parentDatasetRun = datasetRun.parentDatasetRun;
        this.parametersMapExpression = datasetRun.parametersMapExpression;
        this.parameters = datasetRun.parameters;
        this.connectionExpression = datasetRun.getConnectionExpression();
        this.dataSourceExpression = datasetRun.getDataSourceExpression();
        this.returnValues = new FillReturnValues(datasetRun.returnValues, factory);
        this.returnValuesContext = datasetRun.returnValuesContext;
    }

    protected void initReturnValues(JRFillObjectFactory factory) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"init return values");
        }
        this.returnValues = new FillReturnValues(this.parentDatasetRun.getReturnValues(), factory, this.filler);
        this.returnValuesContext = new AbstractVariableReturnValueSourceContext(){

            @Override
            public Object getValue(CommonReturnValue returnValue) {
                return JRFillDatasetRun.this.dataset.getVariableValue(((VariableReturnValue)returnValue).getFromVariable());
            }

            @Override
            public JRVariable getToVariable(String name) {
                return JRFillDatasetRun.this.filler.getVariable(name);
            }

            @Override
            public JRVariable getFromVariable(String name) {
                return JRFillDatasetRun.this.dataset.getVariable(name);
            }
        };
    }

    public void setBand(JRFillBand band) {
        if (this.returnValues != null) {
            this.returnValues.setBand(band);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(JRFillElementDataset elementDataset, byte evaluation) throws JRException {
        if (this.returnValues != null) {
            try {
                this.returnValues.checkReturnValues(this.returnValuesContext);
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
        }
        this.saveReturnVariables();
        Map<String, Object> parameterValues = JRFillSubreport.getParameterValues(this.filler, this.expressionEvaluator, this.parametersMapExpression, this.parameters, evaluation, false, this.dataset.getResourceBundle() != null, false);
        try {
            FillDatasetPosition datasetPosition = new FillDatasetPosition(this.expressionEvaluator.getFillDataset().fillPosition);
            datasetPosition.addAttribute("datasetRunUUID", this.getUUID());
            this.expressionEvaluator.getFillDataset().setCacheRecordIndex(datasetPosition, evaluation);
            this.dataset.setFillPosition(datasetPosition);
            String cacheIncludedProp = JRPropertiesUtil.getOwnProperty(this, "net.sf.jasperreports.data.cache.included");
            boolean cacheIncluded = JRPropertiesUtil.asBoolean(cacheIncludedProp, true);
            this.dataset.setCacheSkipped(!cacheIncluded);
            if (this.dataSourceExpression != null) {
                if (!this.filler.fillContext.hasDataSnapshot() || !cacheIncluded) {
                    JRDataSource dataSource = (JRDataSource)this.expressionEvaluator.evaluate(this.dataSourceExpression, evaluation);
                    this.dataset.setDatasourceParameterValue(parameterValues, dataSource);
                }
            } else if (this.connectionExpression != null) {
                Connection connection = (Connection)this.expressionEvaluator.evaluate(this.connectionExpression, evaluation);
                this.dataset.setConnectionParameterValue(parameterValues, connection);
            }
            this.copyConnectionParameter(parameterValues);
            this.dataset.filterElementDatasets(elementDataset);
            this.dataset.initCalculator();
            this.dataset.setParameterValues(parameterValues);
            this.dataset.evaluateFieldProperties();
            this.dataset.initDatasource();
            this.iterate();
        }
        finally {
            this.dataset.closeDatasource();
            this.dataset.disposeParameterContributors();
            this.dataset.restoreElementDatasets();
        }
        this.copyReturnValues();
    }

    protected void saveReturnVariables() {
        if (this.returnValues != null) {
            this.returnValues.saveReturnVariables();
        }
    }

    public void copyReturnValues() {
        if (this.returnValues != null) {
            this.returnValues.copyValues(this.returnValuesContext);
        }
    }

    protected void copyConnectionParameter(Map<String, Object> parameterValues) {
        JRQuery query = this.dataset.getQuery();
        if (query != null) {
            String language = query.getLanguage();
            if (this.connectionExpression == null && (language.equals("sql") || language.equals("SQL")) && !parameterValues.containsKey("REPORT_CONNECTION")) {
                JRFillParameter connParam = this.expressionEvaluator.getFillDataset().getParametersMap().get("REPORT_CONNECTION");
                Connection connection = (Connection)connParam.getValue();
                parameterValues.put("REPORT_CONNECTION", connection);
            }
        }
    }

    protected void iterate() throws JRException {
        this.dataset.start();
        this.init();
        if (this.advanceDataset()) {
            this.detail();
            while (this.advanceDataset()) {
                this.checkInterrupted();
                this.group();
                this.detail();
            }
        }
    }

    protected boolean advanceDataset() throws JRException {
        return this.dataset.next();
    }

    protected void checkInterrupted() {
        this.filler.checkInterrupted();
    }

    protected void group() throws JRException, JRScriptletException {
        this.dataset.calculator.estimateGroupRuptures();
        this.dataset.delegateScriptlet.callBeforeGroupInit();
        this.dataset.calculator.initializeVariables(ResetTypeEnum.GROUP, IncrementTypeEnum.GROUP);
        this.dataset.delegateScriptlet.callAfterGroupInit();
    }

    protected void init() throws JRScriptletException, JRException {
        this.dataset.delegateScriptlet.callBeforeReportInit();
        this.dataset.calculator.initializeVariables(ResetTypeEnum.REPORT, IncrementTypeEnum.REPORT);
        this.dataset.delegateScriptlet.callAfterReportInit();
    }

    protected void detail() throws JRScriptletException, JRException {
        this.dataset.delegateScriptlet.callBeforeDetailEval();
        this.dataset.calculator.calculateVariables();
        this.dataset.delegateScriptlet.callAfterDetailEval();
    }

    @Override
    public String getDatasetName() {
        return this.dataset.getName();
    }

    @Override
    public JRExpression getParametersMapExpression() {
        return this.parametersMapExpression;
    }

    @Override
    public JRDatasetParameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public JRExpression getConnectionExpression() {
        return this.connectionExpression;
    }

    @Override
    public JRExpression getDataSourceExpression() {
        return this.dataSourceExpression;
    }

    protected JRFillDataset getDataset() {
        return this.dataset;
    }

    @Override
    public UUID getUUID() {
        return this.parentDatasetRun.getUUID();
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasProperties() {
        return this.parentDatasetRun.hasProperties();
    }

    @Override
    public JRPropertiesMap getPropertiesMap() {
        return this.parentDatasetRun.getPropertiesMap();
    }

    @Override
    public JRPropertiesHolder getParentProperties() {
        return null;
    }

    @Override
    public List<ReturnValue> getReturnValues() {
        return this.parentDatasetRun.getReturnValues();
    }
}

