/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.Locale;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.HtmlFontFamily;
import net.sf.jasperreports.engine.fonts.FontFace;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.util.JRDataUtils;

public class HtmlFont {
    private static final String LOCALE_SEPARATOR = "_-";
    private static final int IE_FONT_NAME_MAX_LENGTH = 31;
    private HtmlFontFamily family;
    private Locale locale;
    private String fontName;
    private String ttf;
    private String eot;
    private String svg;
    private String woff;
    private boolean isBold;
    private boolean isItalic;
    private String id;
    private String shortId;

    private HtmlFont(Locale locale, FontFace fontFace, int style) {
        this.locale = locale;
        this.fontName = fontFace.getName();
        this.ttf = fontFace.getTtf();
        this.eot = fontFace.getEot();
        this.svg = fontFace.getSvg();
        this.woff = fontFace.getWoff();
        this.isBold = (style & 1) > 0;
        this.isItalic = (style & 2) > 0;
        this.createIds();
    }

    private HtmlFont(HtmlFontFamily family, Locale locale, FontFace fontFace, boolean isBold, boolean isItalic) {
        this.family = family;
        this.locale = locale;
        this.fontName = fontFace.getName();
        this.ttf = fontFace.getTtf();
        this.eot = fontFace.getEot();
        this.svg = fontFace.getSvg();
        this.woff = fontFace.getWoff();
        this.isBold = isBold;
        this.isItalic = isItalic;
        this.createIds();
    }

    public static HtmlFont getInstance(Locale locale, FontInfo fontInfo, boolean isBold, boolean isItalic) {
        HtmlFont htmlFont = null;
        if (fontInfo != null) {
            FontFamily family = fontInfo.getFontFamily();
            FontFace fontFace = fontInfo.getFontFace();
            if (fontFace != null) {
                htmlFont = HtmlFont.getInstance(locale, fontFace, fontInfo.getStyle());
            }
            if (htmlFont == null && isBold && isItalic && (fontFace = family.getBoldItalicFace()) != null) {
                htmlFont = HtmlFont.getInstance(locale, fontFace, 3);
            }
            if (htmlFont == null && isBold && (fontFace = family.getBoldFace()) != null) {
                htmlFont = HtmlFont.getInstance(locale, fontFace, 1);
            }
            if (htmlFont == null && isItalic && (fontFace = family.getItalicFace()) != null) {
                htmlFont = HtmlFont.getInstance(locale, fontFace, 2);
            }
            if (htmlFont == null && (fontFace = family.getNormalFace()) != null) {
                htmlFont = HtmlFont.getInstance(locale, fontFace, 0);
            }
        }
        return htmlFont;
    }

    public static HtmlFont getInstance(JasperReportsContext jasperReportsContext, String htmlFontId) {
        int localeSeparatorPos = htmlFontId.lastIndexOf(LOCALE_SEPARATOR);
        String faceName = htmlFontId.substring(0, localeSeparatorPos);
        boolean isBold = false;
        boolean isItalic = false;
        if (faceName.endsWith("-Italic")) {
            faceName = faceName.substring(0, faceName.length() - "-Italic".length());
            isItalic = true;
        }
        if (faceName.endsWith("-Bold")) {
            faceName = faceName.substring(0, faceName.length() - "-Bold".length());
            isBold = true;
        }
        if (faceName.endsWith("-BoldItalic")) {
            faceName = faceName.substring(0, faceName.length() - "-BoldItalic".length());
            isItalic = true;
            isBold = true;
        }
        String localeCode = htmlFontId.substring(localeSeparatorPos + LOCALE_SEPARATOR.length());
        Locale locale = JRDataUtils.getLocale(localeCode);
        FontInfo fontInfo = FontUtil.getInstance(jasperReportsContext).getFontInfo(faceName, locale);
        return HtmlFont.getInstance(locale, fontInfo, isBold, isItalic);
    }

    public static HtmlFont getInstance(HtmlFontFamily family, Locale locale, FontFace fontFace, boolean isBold, boolean isItalic) {
        HtmlFont htmlFont = null;
        if (fontFace.getTtf() != null || fontFace.getEot() != null || fontFace.getSvg() != null || fontFace.getWoff() != null) {
            htmlFont = new HtmlFont(family, locale, fontFace, isBold, isItalic);
        }
        return htmlFont;
    }

    public static HtmlFont getInstance(Locale locale, FontFace fontFace, int style) {
        HtmlFont htmlFont = null;
        if (fontFace.getTtf() != null || fontFace.getEot() != null || fontFace.getSvg() != null || fontFace.getWoff() != null) {
            htmlFont = new HtmlFont(locale, fontFace, style);
        }
        return htmlFont;
    }

    private void createIds() {
        String prefix = this.fontName;
        String suffix = (this.isBold || this.isItalic ? "-" : "") + (this.isBold ? "Bold" : "") + (this.isItalic ? "Italic" : "") + (this.locale == null ? "" : LOCALE_SEPARATOR + JRDataUtils.getLocaleCode(this.locale));
        this.id = prefix + suffix;
        if (prefix.length() + suffix.length() > 31) {
            prefix = prefix.replaceAll("\\s", "");
        }
        if (prefix.length() + suffix.length() > 31) {
            suffix = (this.isBold || this.isItalic ? "-" : "") + (this.isBold ? "B" : "") + (this.isItalic ? "I" : "") + (this.locale == null ? "" : LOCALE_SEPARATOR + JRDataUtils.getLocaleCode(this.locale));
        }
        if (prefix.length() + suffix.length() > 31) {
            prefix = prefix.substring(0, 1) + prefix.substring(1).replaceAll("[AaEeIiOoUu]", "");
        }
        if (prefix.length() + suffix.length() > 31) {
            prefix = prefix.substring(0, 31 - suffix.length());
        }
        this.shortId = prefix + suffix;
    }

    public String getId() {
        return this.id;
    }

    public String getShortId() {
        return this.shortId;
    }

    public HtmlFontFamily getFamily() {
        return this.family;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getFontName() {
        return this.fontName;
    }

    public String getTtf() {
        return this.ttf;
    }

    public String getEot() {
        return this.eot;
    }

    public String getSvg() {
        return this.svg;
    }

    public String getWoff() {
        return this.woff;
    }

    public int getStyle() {
        return (this.isBold ? 1 : 0) | (this.isItalic ? 2 : 0);
    }

    public boolean isBold() {
        return this.isBold;
    }

    public boolean isItalic() {
        return this.isItalic;
    }
}

