/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export;

import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.export.CommonExportConfiguration;
import net.sf.jasperreports.export.annotations.ExporterProperty;

public class PropertiesExporterConfigurationFactory<C extends CommonExportConfiguration> {
    public static final String EXCEPTION_MESSAGE_KEY_EXPORT_PROPERTIES_EMPTY_STRING_DEFAULT_NOT_SUPPORTED = "export.common.properties.empty.string.default.not.supported";
    public static final String EXCEPTION_MESSAGE_KEY_EXPORT_PROPERTIES_TYPE_NOT_SUPPORTED = "export.common.properties.type.not.supported";

    public static Object getPropertyValue(JasperReportsContext jasperReportsContext, JRPropertiesHolder propertiesHolder, ExporterProperty exporterProperty, Class<?> type) {
        Object value = null;
        String propertyName = exporterProperty.value();
        if (String[].class.equals(type)) {
            List<JRPropertiesUtil.PropertySuffix> properties = JRPropertiesUtil.getProperties(propertiesHolder, propertyName);
            if (properties != null && !properties.isEmpty()) {
                String[] values = new String[properties.size()];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = properties.get(i).getValue();
                }
                value = values;
            }
        } else if (JRPropertiesUtil.PropertySuffix[].class.equals(type)) {
            List<JRPropertiesUtil.PropertySuffix> properties = JRPropertiesUtil.getProperties(propertiesHolder, propertyName);
            if (properties != null && !properties.isEmpty()) {
                value = properties.toArray(new JRPropertiesUtil.PropertySuffix[properties.size()]);
            }
        } else {
            JRPropertiesUtil propertiesUtil = JRPropertiesUtil.getInstance(jasperReportsContext);
            if (String.class.equals(type)) {
                value = propertiesUtil.getProperty(propertiesHolder, propertyName);
            } else if (Character.class.equals(type)) {
                value = propertiesUtil.getCharacterProperty(propertiesHolder, propertyName);
            } else if (Integer.class.equals(type)) {
                value = exporterProperty.nullDefault() ? propertiesUtil.getIntegerProperty(propertiesHolder, propertyName) : Integer.valueOf(propertiesUtil.getIntegerProperty(propertiesHolder, propertyName, exporterProperty.intDefault()));
            } else if (Long.class.equals(type)) {
                value = propertiesUtil.getLongProperty(propertiesHolder, propertyName, exporterProperty.longDefault());
            } else if (Float.class.equals(type)) {
                value = exporterProperty.nullDefault() ? propertiesUtil.getFloatProperty(propertiesHolder, propertyName) : Float.valueOf(propertiesUtil.getFloatProperty(propertiesHolder, propertyName, exporterProperty.floatDefault()));
            } else if (Boolean.class.equals(type)) {
                value = propertiesUtil.getBooleanProperty(propertiesHolder, propertyName, exporterProperty.booleanDefault());
            } else if (Color.class.equals(type)) {
                String strValue = propertiesUtil.getProperty(propertiesHolder, propertyName);
                if (strValue == null && !exporterProperty.nullDefault() && (strValue = exporterProperty.stringDefault()).trim().length() == 0) {
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_EXPORT_PROPERTIES_EMPTY_STRING_DEFAULT_NOT_SUPPORTED, new Object[]{propertyName});
                }
                if (strValue != null) {
                    value = JRColorUtil.getColor(strValue, null);
                }
            } else if (NamedEnum.class.isAssignableFrom(type)) {
                value = propertiesUtil.getProperty(propertiesHolder, propertyName);
                try {
                    Method byNameMethod = type.getMethod("getByName", String.class);
                    value = byNameMethod.invoke(null, value);
                }
                catch (NoSuchMethodException e) {
                    throw new JRRuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new JRRuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new JRRuntimeException(e);
                }
            } else {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_EXPORT_PROPERTIES_TYPE_NOT_SUPPORTED, new Object[]{type});
            }
        }
        return value;
    }
}

