/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxBorderHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxFontHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxFormatHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxStyleInfo;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.util.FileBufferedWriter;
import net.sf.jasperreports.export.XlsReportConfiguration;

public class XlsxStyleHelper
extends BaseHelper {
    private FileBufferedWriter formatsWriter = new FileBufferedWriter();
    private FileBufferedWriter fontsWriter = new FileBufferedWriter();
    private FileBufferedWriter fillsWriter = new FileBufferedWriter();
    private FileBufferedWriter bordersWriter = new FileBufferedWriter();
    private FileBufferedWriter cellXfsWriter = new FileBufferedWriter();
    private Map<String, Integer> styleCache = new HashMap<String, Integer>();
    private XlsxFormatHelper formatHelper;
    private XlsxFontHelper fontHelper;
    private XlsxBorderHelper borderHelper;

    public XlsxStyleHelper(JasperReportsContext jasperReportsContext, Writer writer, String exporterKey) {
        super(jasperReportsContext, writer);
        this.formatHelper = new XlsxFormatHelper(jasperReportsContext, this.formatsWriter);
        this.fontHelper = new XlsxFontHelper(jasperReportsContext, this.fontsWriter, exporterKey);
        this.borderHelper = new XlsxBorderHelper(jasperReportsContext, this.bordersWriter);
    }

    public void setConfiguration(XlsReportConfiguration configuration) {
        this.fontHelper.setConfiguration(configuration);
    }

    public int getCellStyle(JRExporterGridCell gridCell, String pattern, Locale locale, boolean isWrapText, boolean isHidden, boolean isLocked, boolean isShrinkToFit, boolean isIgnoreTextFormatting, RotationEnum rotation, JRXlsAbstractExporter.SheetInfo sheetInfo) {
        XlsxStyleInfo styleInfo = new XlsxStyleInfo(this.formatHelper.getFormat(pattern) + 1, this.fontHelper.getFont(gridCell, locale) + 1, this.borderHelper.getBorder(gridCell, sheetInfo) + 1, gridCell, isWrapText, isHidden, isLocked, isShrinkToFit, isIgnoreTextFormatting, this.getRotation(rotation), sheetInfo);
        Integer styleIndex = this.styleCache.get(styleInfo.getId());
        if (styleIndex == null) {
            styleIndex = this.styleCache.size() + 1;
            this.exportCellStyle(gridCell, styleInfo, styleIndex, sheetInfo);
            this.styleCache.put(styleInfo.getId(), styleIndex);
        }
        return styleIndex;
    }

    private void exportCellStyle(JRExporterGridCell gridCell, XlsxStyleInfo styleInfo, Integer styleIndex, JRXlsAbstractExporter.SheetInfo sheetInfo) {
        try {
            if (Boolean.TRUE.equals(sheetInfo.ignoreCellBackground) || styleInfo.backcolor == null) {
                if (Boolean.TRUE.equals(sheetInfo.whitePageBackground)) {
                    this.fillsWriter.write("<fill><patternFill patternType=\"solid\"><fgColor rgb=\"FFFFFF\"/></patternFill></fill>\n");
                } else {
                    this.fillsWriter.write("<fill><patternFill patternType=\"none\"/></fill>\n");
                }
            } else {
                this.fillsWriter.write("<fill><patternFill patternType=\"solid\"><fgColor rgb=\"" + styleInfo.backcolor + "\"/></patternFill></fill>\n");
            }
            this.cellXfsWriter.write("<xf numFmtId=\"" + styleInfo.formatIndex + "\" fontId=\"" + styleInfo.fontIndex + "\" fillId=\"" + (styleIndex + 1) + "\" borderId=\"" + styleInfo.borderIndex + "\" xfId=\"" + styleIndex + "\" applyAlignment=\"1\" applyProtection=\"1\" applyNumberFormat=\"1\" applyFont=\"1\" applyFill=\"1\" applyBorder=\"1\"><alignment wrapText=\"" + (styleInfo.isWrapText && !styleInfo.isShrinkToFit) + "\"" + (styleInfo.horizontalAlign == null ? "" : " horizontal=\"" + styleInfo.horizontalAlign + "\"") + (styleInfo.verticalAlign == null ? "" : " vertical=\"" + styleInfo.verticalAlign + "\"") + (styleInfo.isShrinkToFit ? " shrinkToFit=\"" + styleInfo.isShrinkToFit + "\"" : "") + (styleInfo.rotation != 0 ? " textRotation=\"" + styleInfo.rotation + "\"" : "") + "/>");
            this.cellXfsWriter.write("<protection hidden=\"" + styleInfo.isHidden + "\" locked=\"" + styleInfo.isLocked + "\"/>");
            this.cellXfsWriter.write("</xf>\n");
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public void export() {
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.write("<styleSheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\">\n");
        this.write("<numFmts>\n");
        this.write("<numFmt numFmtId=\"0\" formatCode=\"General\"/>\n");
        this.formatsWriter.writeData(this.writer);
        this.write("</numFmts>\n");
        this.write("<fonts>\n");
        this.write("<font><sz val=\"11\"/><color theme=\"1\"/><name val=\"Calibri\"/><family val=\"2\"/><scheme val=\"minor\"/></font>\n");
        this.fontsWriter.writeData(this.writer);
        this.write("</fonts>\n");
        this.write("<fills>\n");
        this.write("<fill><patternFill patternType=\"none\"/></fill>\n");
        this.write("<fill><patternFill patternType=\"solid\"><fgColor rgb=\"FFFFFF\"/></patternFill></fill>\n");
        this.fillsWriter.writeData(this.writer);
        this.write("</fills>\n");
        this.write("<borders>\n");
        this.write("<border><left/><right/><top/><bottom/><diagonal/></border>\n");
        this.bordersWriter.writeData(this.writer);
        this.write("</borders>\n");
        this.write("<cellXfs>\n");
        this.write("<xf numFmtId=\"0\" fontId=\"0\" fillId=\"0\" borderId=\"0\" xfId=\"0\" applyAlignment=\"1\" applyProtection=\"1\" applyNumberFormat=\"1\" applyFont=\"1\" applyFill=\"1\" applyBorder=\"1\"/>\n");
        this.cellXfsWriter.writeData(this.writer);
        this.write("</cellXfs>\n");
        this.write("<dxfs count=\"0\"/><tableStyles count=\"0\" defaultTableStyle=\"TableStyleMedium9\" defaultPivotStyle=\"PivotStyleLight16\"/>\n");
        this.write("</styleSheet>\n");
    }

    protected int getRotation(RotationEnum rotation) {
        int result = 0;
        if (rotation != null) {
            switch (rotation) {
                case LEFT: {
                    result = 90;
                    break;
                }
                case RIGHT: {
                    result = 180;
                    break;
                }
            }
        }
        return result;
    }
}

