/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import java.util.Locale;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.ElementGridCell;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.OccupiedGridCell;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.TypeTextValueHandler;
import net.sf.jasperreports.engine.export.ooxml.XlsxStyleHelper;
import net.sf.jasperreports.engine.type.RotationEnum;

public class XlsxCellHelper
extends BaseHelper {
    private XlsxStyleHelper styleHelper;
    private final TypeTextValueHandler textValueHandler = new TypeTextValueHandler();

    public XlsxCellHelper(JasperReportsContext jasperReportsContext, Writer writer, XlsxStyleHelper styleHelper) {
        super(jasperReportsContext, writer);
        this.styleHelper = styleHelper;
    }

    public void exportHeader(JRExporterGridCell gridCell, int rowIndex, int colIndex, int maxColIndex, JRXlsAbstractExporter.SheetInfo sheetInfo) {
        this.exportHeader(gridCell, rowIndex, colIndex, maxColIndex, null, null, null, true, false, false, false, false, RotationEnum.NONE, sheetInfo);
    }

    public void exportHeader(JRExporterGridCell gridCell, int rowIndex, int colIndex, int maxColIndex, TextValue textValue, String pattern, Locale locale, boolean isWrapText, boolean isHidden, boolean isLocked, boolean isShrinkToFit, boolean isIgnoreTextFormatting, RotationEnum rotation, JRXlsAbstractExporter.SheetInfo sheetInfo) {
        try {
            if (textValue != null) {
                textValue.handle(this.textValueHandler);
            } else {
                this.textValueHandler.handle((StringTextValue)null);
            }
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        Integer styleIndex = null;
        if (gridCell.getType() == 2) {
            styleIndex = ((ElementGridCell)((OccupiedGridCell)gridCell).getOccupier()).getStyleIndex();
        }
        if (styleIndex == null) {
            styleIndex = this.styleHelper.getCellStyle(gridCell, pattern, locale, isWrapText, isHidden, isLocked, isShrinkToFit, isIgnoreTextFormatting, rotation, sheetInfo);
            if (gridCell.getType() == 3 && gridCell instanceof ElementGridCell) {
                ((ElementGridCell)gridCell).setStyleIndex(styleIndex);
            }
        }
        this.write("  <c r=\"" + JRXlsAbstractExporter.getColumIndexName(colIndex, maxColIndex) + (rowIndex + 1) + "\" s=\"" + styleIndex + "\"");
        String type = this.textValueHandler.getType();
        if (type != null) {
            this.write(" t=\"" + type + "\"");
        }
        this.write(">");
    }

    public void exportFooter() {
        this.write("</c>");
    }
}

