/*
 * Decompiled with CFR 0.152.
 */
package de.cenote.jasperstarter;

import de.cenote.jasperstarter.Config;
import de.cenote.jasperstarter.types.DsType;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRCsvDataSource;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import net.sf.jasperreports.engine.data.JsonDataSource;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.lang.StringEscapeUtils;

public class Db {
    public JRCsvDataSource getCsvDataSource(Config config) throws JRException {
        JRCsvDataSource ds;
        try {
            ds = new JRCsvDataSource(JRLoader.getInputStream((File)config.getDataFile()), config.csvCharset);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException("Unknown CSV charset: " + config.csvCharset + ex.getMessage(), ex);
        }
        ds.setUseFirstRowAsHeader(config.getCsvFirstRow());
        if (!config.getCsvFirstRow()) {
            ds.setColumnNames(config.getCsvColumns());
        }
        ds.setRecordDelimiter(StringEscapeUtils.unescapeJava((String)config.getCsvRecordDel()));
        ds.setFieldDelimiter(config.getCsvFieldDel());
        if (config.isVerbose()) {
            System.out.println("Use first row: " + config.getCsvFirstRow());
            System.out.print("CSV Columns:");
            for (String name : config.getCsvColumns()) {
                System.out.print(" " + name);
            }
            System.out.println("");
            System.out.println("-----------------------");
            System.out.println("Record delimiter literal: " + config.getCsvRecordDel());
            System.out.println("Record delimiter: " + ds.getRecordDelimiter());
            System.out.println("Field delimiter: " + ds.getFieldDelimiter());
            System.out.println("-----------------------");
        }
        return ds;
    }

    public JRXmlDataSource getXmlDataSource(Config config) throws JRException {
        JRXmlDataSource ds = new JRXmlDataSource(JRLoader.getInputStream((File)config.getDataFile()), config.xmlXpath);
        if (config.isVerbose()) {
            System.out.println("Data file: " + config.getDataFile());
            System.out.println("XML xpath: " + config.xmlXpath);
        }
        return ds;
    }

    public JsonDataSource getJsonDataSource(Config config) throws JRException {
        JsonDataSource ds = new JsonDataSource(JRLoader.getInputStream((File)config.getDataFile()), config.jsonQuery);
        if (config.isVerbose()) {
            System.out.println("Data file: " + config.getDataFile());
            System.out.println("JSON query : " + config.jsonQuery);
        }
        return ds;
    }

    public Connection getConnection(Config config) throws ClassNotFoundException, SQLException {
        Connection conn = null;
        DsType dbtype = config.getDbType();
        String host = config.getDbHost();
        String user = config.getDbUser();
        String passwd = config.getDbPasswd();
        String driver = null;
        String dbname = null;
        String port = null;
        String sid = null;
        String connectString = null;
        if (DsType.mysql.equals((Object)dbtype)) {
            driver = DsType.mysql.getDriver();
            port = config.getDbPort().toString();
            dbname = config.getDbName();
            connectString = "jdbc:mysql://" + host + ":" + port + "/" + dbname;
        } else if (DsType.postgres.equals((Object)dbtype)) {
            driver = DsType.postgres.getDriver();
            port = config.getDbPort().toString();
            dbname = config.getDbName();
            connectString = "jdbc:postgresql://" + host + ":" + port + "/" + dbname;
        } else if (DsType.oracle.equals((Object)dbtype)) {
            driver = DsType.oracle.getDriver();
            port = config.getDbPort().toString();
            sid = config.getDbSid();
            connectString = "jdbc:oracle:thin:@" + host + ":" + port + ":" + sid;
        } else if (DsType.generic.equals((Object)dbtype)) {
            driver = config.getDbDriver();
            connectString = config.getDbUrl();
        }
        if (config.isVerbose()) {
            System.out.println("JDBC driver: " + driver);
            System.out.println("Connectstring: " + connectString);
            System.out.println("db-user: " + user);
            if (passwd.isEmpty()) {
                System.out.println("db-password is empty");
            }
        }
        Class.forName(driver);
        conn = DriverManager.getConnection(connectString, user, passwd);
        return conn;
    }
}

