/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.functions.standard;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.sf.jasperreports.functions.AbstractFunctionSupport;
import net.sf.jasperreports.functions.annotations.Function;
import net.sf.jasperreports.functions.annotations.FunctionCategories;
import net.sf.jasperreports.functions.annotations.FunctionParameter;
import net.sf.jasperreports.functions.annotations.FunctionParameters;
import net.sf.jasperreports.functions.standard.DateTimeCategory;
import net.sf.jasperreports.types.date.DateRange;
import net.sf.jasperreports.types.date.DateRangeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.Months;
import org.joda.time.ReadablePartial;
import org.joda.time.Weeks;
import org.joda.time.Years;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@FunctionCategories(value={DateTimeCategory.class})
public final class DateTimeFunctions
extends AbstractFunctionSupport {
    private static final Log log = LogFactory.getLog(DateTimeFunctions.class);

    @Function(value="TODAY")
    public Date TODAY() {
        return Calendar.getInstance(this.getReportTimeZone(), this.getReportLocale()).getTime();
    }

    @Function(value="NOW")
    public Date NOW() {
        return this.TODAY();
    }

    @Function(value="YEAR")
    @FunctionParameters(value={@FunctionParameter(value="dateObject")})
    public Integer YEAR(Object dateObject) {
        return this.getCalendarFieldFromDate(dateObject, 1);
    }

    @Function(value="MONTH")
    @FunctionParameters(value={@FunctionParameter(value="dateObject")})
    public Integer MONTH(Object dateObject) {
        return this.getCalendarFieldFromDate(dateObject, 2) + 1;
    }

    @Function(value="DAY")
    @FunctionParameters(value={@FunctionParameter(value="dateObject")})
    public Integer DAY(Object dateObject) {
        return this.getCalendarFieldFromDate(dateObject, 5);
    }

    @Function(value="WEEKDAY")
    @FunctionParameters(value={@FunctionParameter(value="dateObject"), @FunctionParameter(value="isSundayFirstDay")})
    public Integer WEEKDAY(Object dateObject) {
        return this.WEEKDAY(dateObject, false);
    }

    public Integer WEEKDAY(Object dateObject, Boolean isSundayFirstDay) {
        Integer dayOfWeek = this.getCalendarFieldFromDate(dateObject, 7);
        if (dayOfWeek == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to get the correct day of the week.");
            }
            return null;
        }
        if (isSundayFirstDay.booleanValue()) {
            return dayOfWeek;
        }
        if (dayOfWeek == 1) {
            return 7;
        }
        return dayOfWeek - 1;
    }

    @Function(value="HOUR")
    @FunctionParameters(value={@FunctionParameter(value="dateObject")})
    public Integer HOUR(Object dateObject) {
        return this.getCalendarFieldFromDate(dateObject, 11);
    }

    @Function(value="MINUTE")
    @FunctionParameters(value={@FunctionParameter(value="dateObject")})
    public Integer MINUTE(Object dateObject) {
        return this.getCalendarFieldFromDate(dateObject, 12);
    }

    @Function(value="SECOND")
    @FunctionParameters(value={@FunctionParameter(value="dateObject")})
    public Integer SECOND(Object dateObject) {
        return this.getCalendarFieldFromDate(dateObject, 13);
    }

    @Function(value="DATE")
    @FunctionParameters(value={@FunctionParameter(value="year"), @FunctionParameter(value="month"), @FunctionParameter(value="dayOfMonth")})
    public Date DATE(Integer year, Integer month, Integer dayOfMonth) {
        if (year == null || month == null || dayOfMonth == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"None of the arguments can be null.");
            }
            return null;
        }
        return new DateTime(year.intValue(), month.intValue(), dayOfMonth.intValue(), 0, 0, 0, DateTimeZone.forTimeZone((TimeZone)this.getReportTimeZone())).toDate();
    }

    @Function(value="DATEVALUE")
    @FunctionParameters(value={@FunctionParameter(value="dateObject")})
    public Long DATEVALUE(Object dateObject) {
        Date convertedDate = this.convertDateObject(dateObject);
        if (convertedDate != null) {
            return convertedDate.getTime();
        }
        DateTimeFunctions.logCannotConvertToDate();
        return null;
    }

    @Function(value="TIME")
    @FunctionParameters(value={@FunctionParameter(value="hours"), @FunctionParameter(value="minutes"), @FunctionParameter(value="seconds"), @FunctionParameter(value="timePattern")})
    public static String TIME(Integer hours, Integer minutes, Integer seconds) {
        return DateTimeFunctions.TIME(hours, minutes, seconds, null);
    }

    public static String TIME(Integer hours, Integer minutes, Integer seconds, String timePattern) {
        if (hours == null || minutes == null || seconds == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"None of the arguments can be null.");
            }
            return null;
        }
        LocalTime lt = new LocalTime(hours.intValue(), minutes.intValue(), seconds.intValue());
        if (timePattern == null) {
            return lt.toString(DateTimeFormat.longTime());
        }
        try {
            DateTimeFormatter dtf = DateTimeFormat.forPattern((String)timePattern);
            return lt.toString(dtf);
        }
        catch (IllegalArgumentException ex) {
            return lt.toString(DateTimeFormat.longTime());
        }
    }

    @Function(value="EDATE")
    @FunctionParameters(value={@FunctionParameter(value="dateObject"), @FunctionParameter(value="months")})
    public Date EDATE(Object dateObject, Integer months) {
        Date convertedDate = this.convertDateObject(dateObject);
        if (convertedDate == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        DateTime dt = new DateTime((Object)convertedDate);
        dt = dt.plusMonths(months.intValue());
        return dt.toDate();
    }

    @Function(value="WORKDAY")
    @FunctionParameters(value={@FunctionParameter(value="dateObject"), @FunctionParameter(value="workdays")})
    public Date WORKDAY(Object dateObject, Integer workdays) {
        Date convertedDate = this.convertDateObject(dateObject);
        if (convertedDate == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        boolean lookBack = workdays < 0;
        DateTime cursorDT = new DateTime((Object)convertedDate);
        int remainingDays = Math.abs(workdays);
        while (remainingDays > 0) {
            int dayOfWeek = cursorDT.getDayOfWeek();
            if (dayOfWeek != 6 && dayOfWeek != 7) {
                --remainingDays;
            }
            if (!lookBack) {
                cursorDT = dayOfWeek == 5 ? cursorDT.plusDays(3) : cursorDT.plusDays(1);
                continue;
            }
            cursorDT = dayOfWeek == 1 ? cursorDT.minusDays(3) : cursorDT.minusDays(1);
        }
        return cursorDT.toDate();
    }

    @Function(value="NETWORKDAYS")
    @FunctionParameters(value={@FunctionParameter(value="startDate"), @FunctionParameter(value="endDate")})
    public Integer NETWORKDAYS(Object startDate, Object endDate) {
        Date startDateObj = this.convertDateObject(startDate);
        if (startDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        Date endDateObj = this.convertDateObject(endDate);
        if (endDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        LocalDate cursorLocalDate = new LocalDate((Object)startDateObj);
        LocalDate endLocalDate = new LocalDate((Object)endDateObj);
        int workingDays = 0;
        if (cursorLocalDate.isAfter((ReadablePartial)endLocalDate)) {
            LocalDate tmp = cursorLocalDate;
            cursorLocalDate = endLocalDate;
            endLocalDate = tmp;
        }
        while (Days.daysBetween((ReadablePartial)cursorLocalDate, (ReadablePartial)endLocalDate).getDays() > 0) {
            int dayOfWeek = cursorLocalDate.getDayOfWeek();
            if (dayOfWeek != 6 && dayOfWeek != 7) {
                ++workingDays;
            }
            cursorLocalDate = cursorLocalDate.plusDays(1);
        }
        return workingDays;
    }

    @Function(value="DAYS")
    @FunctionParameters(value={@FunctionParameter(value="startDate"), @FunctionParameter(value="endDate")})
    public Integer DAYS(Object startDate, Object endDate) {
        Date startDateObj = this.convertDateObject(startDate);
        if (startDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        Date endDateObj = this.convertDateObject(endDate);
        if (endDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        LocalDate dt1 = new LocalDate((Object)startDateObj);
        LocalDate dt2 = new LocalDate((Object)endDateObj);
        return Days.daysBetween((ReadablePartial)dt1, (ReadablePartial)dt2).getDays();
    }

    @Function(value="DAYSINMONTH")
    @FunctionParameters(value={@FunctionParameter(value="dateObj")})
    public Integer DAYSINMONTH(Object dateObj) {
        Date date = this.convertDateObject(dateObj);
        if (date == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        DateTime dt = new DateTime((Object)date);
        return dt.dayOfMonth().getMaximumValue();
    }

    @Function(value="DAYSINYEAR")
    @FunctionParameters(value={@FunctionParameter(value="dateObj")})
    public Integer DAYSINYEAR(Object dateObj) {
        Date date = this.convertDateObject(dateObj);
        if (date == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        DateTime dt = new DateTime((Object)date);
        return dt.dayOfYear().getMaximumValue();
    }

    @Function(value="WEEKS")
    @FunctionParameters(value={@FunctionParameter(value="startDate"), @FunctionParameter(value="endDate")})
    public Integer WEEKS(Object startDate, Object endDate) {
        Date startDateObj = this.convertDateObject(startDate);
        if (startDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        Date endDateObj = this.convertDateObject(endDate);
        if (endDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        LocalDate dt1 = new LocalDate((Object)startDateObj);
        LocalDate dt2 = new LocalDate((Object)endDateObj);
        return Weeks.weeksBetween((ReadablePartial)dt1, (ReadablePartial)dt2).getWeeks();
    }

    @Function(value="WEEKSINYEAR")
    @FunctionParameters(value={@FunctionParameter(value="dateObj")})
    public Integer WEEKSINYEAR(Object dateObj) {
        Date date = this.convertDateObject(dateObj);
        if (date == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        DateTime dt = new DateTime((Object)date);
        return dt.weekOfWeekyear().getMaximumValue();
    }

    @Function(value="WEEKNUM")
    @FunctionParameters(value={@FunctionParameter(value="dateObj")})
    public Integer WEEKNUM(Object dateObj) {
        Date date = this.convertDateObject(dateObj);
        if (date == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        DateTime dt = new DateTime((Object)date);
        return dt.getWeekOfWeekyear();
    }

    @Function(value="MONTHS")
    @FunctionParameters(value={@FunctionParameter(value="startDate"), @FunctionParameter(value="endDate")})
    public Integer MONTHS(Object startDate, Object endDate) {
        Date startDateObj = this.convertDateObject(startDate);
        if (startDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        Date endDateObj = this.convertDateObject(endDate);
        if (endDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        LocalDate dt1 = new LocalDate((Object)startDateObj);
        LocalDate dt2 = new LocalDate((Object)endDateObj);
        return Months.monthsBetween((ReadablePartial)dt1, (ReadablePartial)dt2).getMonths();
    }

    @Function(value="YEARS")
    @FunctionParameters(value={@FunctionParameter(value="startDate"), @FunctionParameter(value="endDate")})
    public Integer YEARS(Object startDate, Object endDate) {
        Date startDateObj = this.convertDateObject(startDate);
        if (startDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        Date endDateObj = this.convertDateObject(endDate);
        if (endDateObj == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        LocalDate dt1 = new LocalDate((Object)startDateObj);
        LocalDate dt2 = new LocalDate((Object)endDateObj);
        return Years.yearsBetween((ReadablePartial)dt1, (ReadablePartial)dt2).getYears();
    }

    @Function(value="ISLEAPYEAR")
    @FunctionParameters(value={@FunctionParameter(value="dateObj")})
    public Boolean ISLEAPYEAR(Object dateObj) {
        Date date = this.convertDateObject(dateObj);
        if (date == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        DateTime dt = new DateTime((Object)date);
        return dt.year().isLeap();
    }

    @Function(value="DATEFORMAT")
    @FunctionParameters(value={@FunctionParameter(value="dateObj"), @FunctionParameter(value="formatPattern")})
    public String DATEFORMAT(Date dateObj, String formatPattern) {
        if (dateObj == null) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)formatPattern);
        formatter = formatter.withLocale(this.getReportLocale());
        return new DateTime((Object)dateObj, DateTimeZone.forTimeZone((TimeZone)this.getReportTimeZone())).toString(formatter);
    }

    @Function(value="DATERANGE")
    @FunctionParameters(value={@FunctionParameter(value="dateExprObj")})
    public static DateRange DATERANGE(Object dateExprObj) {
        DateRangeBuilder dateRangeBuilder = null;
        if (dateExprObj instanceof String) {
            dateRangeBuilder = new DateRangeBuilder((String)dateExprObj);
        } else if (dateExprObj instanceof Date) {
            dateRangeBuilder = new DateRangeBuilder((Date)dateExprObj);
        } else {
            throw new IllegalArgumentException("The input parameter for DATERANGE function can be only a String or a Date object");
        }
        return dateRangeBuilder.toDateRange();
    }

    private Date convertDateObject(Object dateObject) {
        if (dateObject == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The date object can not be null.");
            }
            return null;
        }
        if (dateObject instanceof String) {
            int[] formatTypes;
            for (int formatType : formatTypes = new int[]{2, 3, 1, 0}) {
                try {
                    DateFormat df = DateFormat.getDateInstance(formatType, this.getReportLocale());
                    df.setTimeZone(this.getReportTimeZone());
                    return df.parse((String)dateObject);
                }
                catch (ParseException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Unable to parse the string as Date using the standard SimpleDateFormat.");
                }
            }
            return null;
        }
        if (dateObject instanceof Long) {
            Calendar cal = Calendar.getInstance(this.getReportTimeZone(), this.getReportLocale());
            cal.setTimeInMillis((Long)dateObject);
            return cal.getTime();
        }
        if (dateObject instanceof Date) {
            return (Date)dateObject;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"The specified object is not among the allowed types for Date conversion.");
        }
        return null;
    }

    private Integer getCalendarFieldFromDate(Object dateObject, int field) {
        Date convertedDate = this.convertDateObject(dateObject);
        if (convertedDate == null) {
            DateTimeFunctions.logCannotConvertToDate();
            return null;
        }
        Calendar cal = Calendar.getInstance(this.getReportTimeZone(), this.getReportLocale());
        cal.setTime(convertedDate);
        return cal.get(field);
    }

    private static void logCannotConvertToDate() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unable to convert to a valid Date instance.");
        }
    }

    private TimeZone getReportTimeZone() {
        TimeZone reportTimeZone = TimeZone.getDefault();
        if (this.getContext() != null) {
            reportTimeZone = (TimeZone)this.getContext().getParameterValue("REPORT_TIME_ZONE");
        }
        return reportTimeZone;
    }

    private Locale getReportLocale() {
        Locale reportLocale = Locale.getDefault();
        if (this.getContext() != null) {
            reportLocale = (Locale)this.getContext().getParameterValue("REPORT_LOCALE");
        }
        return reportLocale;
    }
}

